%function Run_KurataModel_Batch()
clear all;
close all;
tic

global strain_no continuous_flg; 

options = odeset('RelTol',1e-12,'AbsTol',1e-12);
ode_file = @KurataModel_ODE;
flux_file = @KurataModel_Flux;

%% Wile Type
strain_no = 1;
continuous_flg = 0;
span = -10:0.1:12;
y0 = getInitialCondition();
y0( 1) = 0.011;        % X
y0( 2) = 4.0/180*1e+3; % GLCex (mM)
y0(12) = 0.0/ 60*1e+3; % ACEex (mM)
[ T1, Y1, FLUX1 ] = runSimulation(ode_file,flux_file,span,y0,options);
Y1 = real(Y1); FLUX1 = real(FLUX1);
plotSimulationResult(T1,Y1,FLUX1,[0 max(span)],[0 5], 5);
fprintf('1\n'); toc

%% Delta pykA/pykF
strain_no = 26;
continuous_flg = 0;
span = -10:0.1:12;
y0 = getInitialCondition();
y0( 1) = 0.011;        % X
y0( 2) = 4.0/180*1e+3; % GLCex
y0(12) = 0.0/ 60*1e+3; % ACEex
y0(35) = 0; % Pyk
[ T2, Y2, FLUX2 ] = runSimulation(ode_file,flux_file,span,y0,options);
Y2 = real(Y2); FLUX2 = real(FLUX2);
plotSimulationResult(T2,Y2,FLUX2,[0 max(span)],[0 5], 5);
fprintf('2\n'); toc

%% Delta pgi
strain_no = 4;
continuous_flg = 0;
span = -10:0.1:30;
y0 = getInitialCondition();
y0( 1) = 0.011;        % X
y0( 2) = 4.0/180*1e+3; % GLCex
y0(12) = 0.0/ 60*1e+3; % ACEex
[ T3, Y3, FLUX3 ] = runSimulation(ode_file,flux_file,span,y0,options);
Y3 = real(Y3); FLUX3 = real(FLUX3);
plotSimulationResult(T3,Y3,FLUX3,[0 max(span)],[0 5], 16);
fprintf('3\n'); toc


%% Delta ppc
strain_no = 25;
continuous_flg = 0;
span = -10:0.1:15;
y0 = getInitialCondition();
y0( 1) = 0.011;         % X
y0( 2) = 4.74/180*1e+3; % GLCex
y0(12) = 0.0 / 60*1e+3; % ACEex
y0(48) = 0; % Ppc
[ T4, Y4, FLUX4 ] = runSimulation(ode_file,flux_file,span,y0,options);
Y4 = real(Y4); FLUX4 = real(FLUX4);
plotSimulationResult(T4,Y4,FLUX4,[0 max(span)],[0 5],5);
fprintf('4\n'); toc

save result_batch.mat T1 Y1 FLUX1 T2 Y2 FLUX2 T3 Y3 FLUX3 T4 Y4 FLUX4;

return



