% Objective: This is the file to use TOMLAB tune the kinetic parameters 
% used in iFBA  
% The initial guess is from the Monod kinetic model 
% Author: Xueyang Feng (fengx@seas.wustl.edu)
% Date: 09/01/2011

clear
clc

% set up initial guesses for iFBA
a=0;
b=0;
c=26;

Ini_umax_L=0.5709;
Ini_umax_A=0.1330;
Ini_umax_P=0.1358;
Ini_Ksl=19.4319;
Ini_Ksa=10.0733;
Ini_Ksp=19.4249;
Ini_kpl=0.4538;
Ini_kal=0.7127;
Ini_kap=0.9433;
Ini_ke=0.0135;
Ini_tL=7.1040;
Ini_Yxl=0.0170;
Ini_Yxa=0.0111;
Ini_Yxp=0.0167;


param(1)=Ini_umax_L;
param(2)=Ini_umax_A;
param(3)=Ini_umax_P;
param(4)=Ini_Ksl;
param(5)=Ini_Ksa;
param(6)=Ini_Ksp;
param(7)=Ini_kpl;
param(8)=Ini_kal;
param(9)=Ini_kap;
param(10)=Ini_ke;
param(11)=Ini_tL;
param(12)=Ini_Yxl;
param(13)=Ini_Yxa;
param(14)=Ini_Yxp;
% param(15)=a;
% param(16)=b; 
% param(17)=c; %%This is for iMFA with tradeoff objective function

lb=param.*0.8;
ub=param.*1.2;
% lb(15)=0;
% lb(16)=0;
% lb(17)=0;
% ub(15)=1e-4;
% ub(16)=0.3;
% ub(17)=34;


%% Set for TOMLAB NLP 
A_ineq=zeros(2,14);
A_ineq(1,13)=-1.61;A_ineq(1,12)=1;
A_ineq(2,14)=-1.09;A_ineq(2,12)=1;
b_ineq=zeros(2,1);

f='getSimulationGap';
g=[];
H=[];
HessPattern = []; 
x_L=lb;
x_U=ub;
Name='iFBA';
x_0=param';
pSepFunc = [];
fLowBnd=0;
A=A_ineq;
b_L=b_ineq;
b_U=[];


% Generate the problem structure using the TOMLAB format
Prob = conAssign(f, g, H, HessPattern, x_L, x_U,Name, x_0, pSepFunc, fLowBnd, A, b_L, b_U);
Prob.optParam.IterPrint=1;
Result = tomRun('snopt',Prob,1);











