% objective: Find the weighting factor of "minizing overall flux" in the
% weighted objective in dFBA.
% Author: Xueyang Feng (fengx@seas.wustl.edu)
% date: 09/01/2011

clear
clc

%% input inflow/outflow from Monod model
global umax_L;
global umax_A;
global umax_P;
global Ksl;
global Ksa;
global Ksp;
global kpl;
global kal;
global kap;
global Yxl;
global Yxa;
global Yxp;
global ke;
global tL;

umax_L=0.5709;
umax_A=0.1330;
umax_P=0.1358;
Ksl=19.4319;
Ksa=10.0733;
Ksp=19.4249;
kpl=0.4538;
kal=0.7127;
kap=0.9433;
ke=0.0135;
tL=7.1040;
Yxl=0.0170;
Yxa=0.0111;
Yxp=0.0167;

%% Monod model input%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tspan=0:1/12:34;
y0=[0.00045738 29.64 0.02 0.01];

[t,y]=ode45(@Monod_kinetics_final,tspan,y0);

X_sim(:,1)=y(:,1);
LACT_sim(:,1)=y(:,2);
ACT_sim(:,1)=y(:,3);
PYR_sim(:,1)=y(:,4);


flux_LACT_inflow=zeros(408,1);
flux_ACT_outflow=zeros(408,1);
flux_PYR_outflow=zeros(408,1);
growth_rate=zeros(408,1);

for i=1:408
    flux_LACT_inflow(i,1)=-(LACT_sim(i+1,1)-LACT_sim(i,1))/X_sim(i,1)*12;
    flux_ACT_outflow(i,1)=(ACT_sim(i+1,1)-ACT_sim(i,1))/X_sim(i,1)*12;
    flux_PYR_outflow(i,1)=(PYR_sim(i+1,1)-PYR_sim(i,1))/X_sim(i,1)*12;
    growth_rate(i,1)=(X_sim(i+1,1)-X_sim(i,1))/X_sim(i,1)*12;
end



%% find the weight in dFBA for all the data%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

S=xlsread('Matrix_final.xlsx',1);
boundary=xlsread('Matrix_final.xlsx',2);
obj_S=zeros(1,775);
obj_S(775)=1;

obj_min=zeros(408,1);
growth_rate_optimized=zeros(408,1);
weight_optimized=zeros(408,1);
tFBA_results_optimized=zeros(775,408);

for time=1:408
    
    if(flux_ACT_outflow(time,1)>0||flux_LACT_inflow(time,1)>0||flux_PYR_outflow(time,1)>0)
        for num_search=1:1:300
            
            stepwidth=1e-6;
            weight=num_search.*stepwidth;
            
            %%%%%%%%%TOMLAB%%%%%%%%%%%%%%%%
            
            F=eye(775).*2.*weight;
            c=-obj_S'.*(1-weight);
            A=S;
            
            lb=boundary(:,2);
            ub=boundary(:,1);
            
            lb(426)=flux_LACT_inflow(time,1);
            ub(426)=flux_LACT_inflow(time,1);
            lb(39)=-flux_ACT_outflow(time,1);
            ub(39)=-flux_ACT_outflow(time,1);
            lb(634)=-flux_PYR_outflow(time,1);
            ub(634)=-flux_PYR_outflow(time,1);
            
            b_L=zeros(634,1);
            b_U=zeros(634,1);
            x_L=lb;
            x_U=ub;
            x_0=[];
            
            % Assign routine for defining a QP problem.
            Prob = qpAssign(F, c, A, b_L, b_U, x_L, x_U, x_0,[],...
                [], [], [], [], []);
            
            Result = tomRun('snopt', Prob, 0);
            
            
            obj_Value=Result.f_k;
            flux_Value=Result.x_k;
            
            tFBA_results(:,num_search)=flux_Value;
            
            growth_rate_tFBA=tFBA_results(775,num_search);
            growth_rate_Monod=growth_rate(time,1);
            obj=(growth_rate_tFBA-growth_rate_Monod)^2;
            weight_search(num_search)=weight;
            growth_rate_search(num_search)=growth_rate_tFBA;
            obj_search(num_search)=obj;
        end
        [min_obj index]=min(obj_search);
        
        growth_rate_opt=growth_rate_search(index);
        
        obj_min(time,1)=min_obj;
        growth_rate_optimized(time,1)=growth_rate_search(index);
        weight_optimized(time,1)=weight_search(index);
        tFBA_results_optimized(:,time)=tFBA_results(:,index);
    end
end

optimized_results.obj=obj_min;
optimized_results.growth_rate_dFBA=growth_rate_optimized;
optimized_results.weight=weight_optimized;
optimized_results.dFBAresults=tFBA_results_optimized;




























