% -----------------------------------------------------------------------
% MASTER-CODE: CODE FOR ALL CALCULATIONS REPRODUCING PLOTS IN PAPER
% -----------------------------------------------------------------------

% -----------------------------------------------------------------------
% Author: Ahmad Abdullah Mannan (c)
% Date: April 2014
% Affiliation : Faculty of Health and Medical Sciences, University of
% Surrey, Guildford, GU2 7TE, UK.
% -----------------------------------------------------------------------


% --- SIMULATING DYNAMICS ABOUT KEIO STEADY STATE -----------------------
% --- TO REPRODUCE PLOT IN FIGURE 4:

% Setting Initial Conditions:
KeioSS = InitConds; % Keio Steady State (KeioSS) Metabolite Concentrations
IC = KeioSS;
IC(13) = IC(13)*0.95; % Perturbed Initial Condition Away from KeioSS

% Solving ODE System (stiff-system) at Keio Steady State and from the
% changed initial condition above:
[t0,x0] = ode15s(@EColi_StableKM_ContCult, [0 10], KeioSS);
[t1,x1] = ode15s(@EColi_StableKM_ContCult, [0 10], IC);

% Calculating System Eigenvalues(EV) at Keio Steady State to Prove Stable:
Jacobian = SystemJacobian(@EColi_StableKM_ContCult,KeioSS);
EV = eig(Jacobian); % All Eigenvalues of system are >= 0, implying stable steady state.
if max(real(EV)) <= 0
    disp(' ** Stable Steady State ** ')
end

% Plotting over all results and reproducing plot in figure 4 of paper:
figure(1)
subplot(2,1,1)
plot(t0,x0,':','LineWidth',2)
hold on; plot(t1,x1,'LineWidth',2); hold off
xlim([0 0.05])
xlabel('Time (h)')
ylabel('Concentrations (mM)')
title('Trajectories of Metabolite Concentration Dynamics Close to Keio Steady State')

subplot(2,1,2)
plot(t0,x0,':','LineWidth',2)
hold on; plot(t1,x1,'LineWidth',2); hold off
axis([0 0.05 0.17 0.3])
xlabel('Time (h)')
ylabel('Concentrations (mM)')
title('Reproduction of Figure 4 of Paper')


% --- FINDING ALTERNATIVE STABLE STEADY STATE ---------------------------
% --- TO REPRODUCE PLOTS IN FIGURE 5:

% Setting Initial Conditions:
KeioSS = InitConds; % Keio Steady State (KeioSS) Metabolite Concentrations
IC2 = KeioSS;
IC2(13) = IC2(13)*0.8; % Perturbed Initial Condition Away from KeioSS

% Solving ODE System (stiff-system) at Keio Steady State and from the
% changed initial condition above:
[t2,x2] = ode15s(@EColi_ContCult_NoGlcOrXDyn, [0 2], IC2);

% Calculating System Eigenvalues(EV) at Alternative Steady State to Prove
% its Stable, thus showing it represents an Alternative Metabolic Phenotype
Jacobian2 = SystemJacobian(@EColi_ContCult_NoGlcOrXDyn, x2(end,:));
EV2 = eig(Jacobian2); % All Eigenvalues of system are >= 0, implying stable steady state.
if max(real(EV2)) <= 0
    disp(' ** Stable Steady State ** ')
end

% Plotting over all results and reproducing plot in figure 4 of paper:
figure(3)
subplot(2,3,1)
plot(t0,x0,':','LineWidth',2)
hold on; plot(t2,x2,'LineWidth',2); hold off
axis([0 2 0.995 1.02])
xlabel('Time (h)')
ylabel('Concentrations (mM)')
title({'Alternative Steady State for [Cit]','Please See Figure 5 In Paper'})

subplot(2,3,2)
plot(t0,x0,':','LineWidth',2)
hold on; plot(t2,x2,'LineWidth',2); hold off
axis([0 2 0.495 0.525])
xlabel('Time (h)')
ylabel('Concentrations (mM)')
title({'Alternative Steady State: [3PG] and [2PG]','Please See Figure 5 In Paper'})

subplot(2,3,3)
plot(t0,x0,':','LineWidth',2)
hold on; plot(t2,x2,'LineWidth',2); hold off
axis([0 2 0.17 0.31])
xlabel('Time (h)')
ylabel('Concentrations (mM)')
title({'Alternative Steady State: [13DPG],[S7P],[ACCOA],[G6P]','Please See Figure 5 In Paper'})

subplot(2,3,4)
plot(t0,x0,':','LineWidth',2)
hold on; plot(t2,x2,'LineWidth',2); hold off
axis([0 2 0.1255 0.1315])
xlabel('Time (h)')
ylabel('Concentrations (mM)')
title({'Alternative Steady State: [Xu5PD],[PYR],[Ru5PD],[DHAP]','Please See Figure 5 In Paper'})

subplot(2,3,5)
plot(t0,x0,':','LineWidth',2)
hold on; plot(t2,x2,'LineWidth',2); hold off
axis([0 2 0.025 0.037])
xlabel('Time (h)')
ylabel('Concentrations (mM)')
title({'Alternative Steady State: [R5P],[OAA],[AKG],[FDP]','Please See Figure 5 In Paper'})
