<?xml version="1.0" encoding="UTF-8"?>
<!-- generated with COPASI 4.8 (Build 35) (http://www.copasi.org) at 2014-07-21 08:39:30 UTC -->
<?oxygen RNGSchema="http://www.copasi.org/static/schema/CopasiML.rng" type="xml"?>
<COPASI xmlns="http://www.copasi.org/static/schema" versionMajor="1" versionMinor="0" versionDevel="35">
  <ListOfFunctions>
    <Function key="Function_66" name="function_4_PTS_Glc" type="UserDefined" reversible="false">
      <Expression>
        Pint/(Pint+kaPint_PTS_Glc)*(kiFBP_PTS_Glc/(FBP+kiFBP_PTS_Glc))*Vmax_PTS_Glc*(Glucose/kmGlucose_PTS_Glc)*(PEP/kmPEP_PTS_Glc)/((1+Glucose/kmGlucose_PTS_Glc)*(1+PEP/kmPEP_PTS_Glc)+(1+G6P/kmG6P_PTS_Glc)*(1+PYR/kmPYR_PTS_Glc)-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_464" name="FBP" order="0" role="modifier"/>
        <ParameterDescription key="FunctionParameter_465" name="G6P" order="1" role="product"/>
        <ParameterDescription key="FunctionParameter_466" name="Glucose" order="2" role="substrate"/>
        <ParameterDescription key="FunctionParameter_467" name="PEP" order="3" role="substrate"/>
        <ParameterDescription key="FunctionParameter_468" name="PYR" order="4" role="product"/>
        <ParameterDescription key="FunctionParameter_469" name="Pint" order="5" role="modifier"/>
        <ParameterDescription key="FunctionParameter_470" name="Vmax_PTS_Glc" order="6" role="constant"/>
        <ParameterDescription key="FunctionParameter_471" name="kaPint_PTS_Glc" order="7" role="constant"/>
        <ParameterDescription key="FunctionParameter_472" name="kiFBP_PTS_Glc" order="8" role="constant"/>
        <ParameterDescription key="FunctionParameter_473" name="kmG6P_PTS_Glc" order="9" role="constant"/>
        <ParameterDescription key="FunctionParameter_474" name="kmGlucose_PTS_Glc" order="10" role="constant"/>
        <ParameterDescription key="FunctionParameter_475" name="kmPEP_PTS_Glc" order="11" role="constant"/>
        <ParameterDescription key="FunctionParameter_476" name="kmPYR_PTS_Glc" order="12" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_67" name="function_4_ATPase" type="UserDefined" reversible="false">
      <Expression>
        Vmax_ATPase*((ATP/kmATP_ATPase)^nATPase/((ATP/kmATP_ATPase)^nATPase+1))
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_453" name="ATP" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_452" name="Vmax_ATPase" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_455" name="kmATP_ATPase" order="2" role="constant"/>
        <ParameterDescription key="FunctionParameter_451" name="nATPase" order="3" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_68" name="function_4_P_transp" type="UserDefined" reversible="false">
      <Expression>
        kiPint_Ptransport/(Pint+kiPint_Ptransport)*Vmax_Ptransport*(ATP/kmATP_Ptransport)*(Pext/kmPext_Ptransport)/((1+Pext/kmPext_Ptransport)*(1+ATP/kmATP_Ptransport)+(1+Pint/kmPint_Ptransport+(Pint/kmPint_Ptransport)^2)*(1+ADP/kmADP_Ptransport)-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_495" name="ADP" order="0" role="product"/>
        <ParameterDescription key="FunctionParameter_496" name="ATP" order="1" role="substrate"/>
        <ParameterDescription key="FunctionParameter_497" name="Pext" order="2" role="substrate"/>
        <ParameterDescription key="FunctionParameter_498" name="Pint" order="3" role="product"/>
        <ParameterDescription key="FunctionParameter_499" name="Vmax_Ptransport" order="4" role="constant"/>
        <ParameterDescription key="FunctionParameter_500" name="kiPint_Ptransport" order="5" role="constant"/>
        <ParameterDescription key="FunctionParameter_501" name="kmADP_Ptransport" order="6" role="constant"/>
        <ParameterDescription key="FunctionParameter_502" name="kmATP_Ptransport" order="7" role="constant"/>
        <ParameterDescription key="FunctionParameter_503" name="kmPext_Ptransport" order="8" role="constant"/>
        <ParameterDescription key="FunctionParameter_504" name="kmPint_Ptransport" order="9" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_69" name="function_4_PGI" type="UserDefined" reversible="true">
      <Expression>
        (Vmax_PGI*(G6P/kmG6P_PGI)-Vmax_PGI/Keq_PGI*(F6P/kmG6P_PGI))/(1+G6P/kmG6P_PGI+F6P/kmF6P_PGI)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_457" name="F6P" order="0" role="product"/>
        <ParameterDescription key="FunctionParameter_490" name="G6P" order="1" role="substrate"/>
        <ParameterDescription key="FunctionParameter_459" name="Keq_PGI" order="2" role="constant"/>
        <ParameterDescription key="FunctionParameter_493" name="Vmax_PGI" order="3" role="constant"/>
        <ParameterDescription key="FunctionParameter_515" name="kmF6P_PGI" order="4" role="constant"/>
        <ParameterDescription key="FunctionParameter_516" name="kmG6P_PGI" order="5" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_70" name="function_4_PFK" type="UserDefined" reversible="false">
      <Expression>
        Vmax_PFK*(F6P/kmF6P_PFK)*(ATP/kmATP_PFK)/((1+F6P/kmF6P_PFK)*(1+ATP/kmATP_PFK)+(1+FBP/kmFBP_PFK)*(1+ADP/kmADP_PFK)-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_526" name="ADP" order="0" role="product"/>
        <ParameterDescription key="FunctionParameter_527" name="ATP" order="1" role="substrate"/>
        <ParameterDescription key="FunctionParameter_528" name="F6P" order="2" role="substrate"/>
        <ParameterDescription key="FunctionParameter_529" name="FBP" order="3" role="product"/>
        <ParameterDescription key="FunctionParameter_530" name="Vmax_PFK" order="4" role="constant"/>
        <ParameterDescription key="FunctionParameter_531" name="kmADP_PFK" order="5" role="constant"/>
        <ParameterDescription key="FunctionParameter_532" name="kmATP_PFK" order="6" role="constant"/>
        <ParameterDescription key="FunctionParameter_533" name="kmF6P_PFK" order="7" role="constant"/>
        <ParameterDescription key="FunctionParameter_534" name="kmFBP_PFK" order="8" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_71" name="function_4_FBA" type="UserDefined" reversible="true">
      <Expression>
        (Vmax_FBA*(FBP/kmFBP_FBA)-Vmax_FBA/Keq_FBA*(G3P^2/kmFBP_FBA))/(1+FBP/kmFBP_FBA+G3P/kmG3P_FBA+(G3P/kmG3P_FBA)^2)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_463" name="FBP" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_494" name="G3P" order="1" role="product"/>
        <ParameterDescription key="FunctionParameter_524" name="Keq_FBA" order="2" role="constant"/>
        <ParameterDescription key="FunctionParameter_544" name="Vmax_FBA" order="3" role="constant"/>
        <ParameterDescription key="FunctionParameter_545" name="kmFBP_FBA" order="4" role="constant"/>
        <ParameterDescription key="FunctionParameter_546" name="kmG3P_FBA" order="5" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_72" name="function_4_GAPDH" type="UserDefined" reversible="true">
      <Expression>
        (Vmax_GAPDH*(G3P/kmG3P_GAPDH)*(NAD/kmNAD_GAPDH)*(Pint/kmPint_GAPDH)-Vmax_GAPDH/Keq_GAPDH*(BPG/kmG3P_GAPDH)*(NADH/kmNAD_GAPDH)*(1/kmPint_GAPDH))/((1+G3P/kmG3P_GAPDH)*(1+Pint/kmPint_GAPDH)*(1+NAD/kmNAD_GAPDH)+(1+BPG/kmBPG_GAPDH)*(1+NADH/kmNADH_GAPDH)-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_559" name="BPG" order="0" role="product"/>
        <ParameterDescription key="FunctionParameter_560" name="G3P" order="1" role="substrate"/>
        <ParameterDescription key="FunctionParameter_561" name="Keq_GAPDH" order="2" role="constant"/>
        <ParameterDescription key="FunctionParameter_562" name="NAD" order="3" role="substrate"/>
        <ParameterDescription key="FunctionParameter_563" name="NADH" order="4" role="product"/>
        <ParameterDescription key="FunctionParameter_564" name="Pint" order="5" role="substrate"/>
        <ParameterDescription key="FunctionParameter_565" name="Vmax_GAPDH" order="6" role="constant"/>
        <ParameterDescription key="FunctionParameter_566" name="kmBPG_GAPDH" order="7" role="constant"/>
        <ParameterDescription key="FunctionParameter_567" name="kmG3P_GAPDH" order="8" role="constant"/>
        <ParameterDescription key="FunctionParameter_568" name="kmNADH_GAPDH" order="9" role="constant"/>
        <ParameterDescription key="FunctionParameter_569" name="kmNAD_GAPDH" order="10" role="constant"/>
        <ParameterDescription key="FunctionParameter_570" name="kmPint_GAPDH" order="11" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_73" name="function_4_ENO" type="UserDefined" reversible="true">
      <Expression>
        (Vmax_ENO*(BPG/kmBPG_ENO)*(ADP/kmADP_ENO)-Vmax_ENO/Keq_ENO*(PEP/kmBPG_ENO)*(ATP/kmADP_ENO))/((1+BPG/kmBPG_ENO)*(1+ADP/kmADP_ENO)+(1+PEP/kmPEP_ENO)*(1+ATP/kmATP_ENO)-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_491" name="ADP" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_555" name="ATP" order="1" role="product"/>
        <ParameterDescription key="FunctionParameter_583" name="BPG" order="2" role="substrate"/>
        <ParameterDescription key="FunctionParameter_584" name="Keq_ENO" order="3" role="constant"/>
        <ParameterDescription key="FunctionParameter_585" name="PEP" order="4" role="product"/>
        <ParameterDescription key="FunctionParameter_586" name="Vmax_ENO" order="5" role="constant"/>
        <ParameterDescription key="FunctionParameter_587" name="kmADP_ENO" order="6" role="constant"/>
        <ParameterDescription key="FunctionParameter_588" name="kmATP_ENO" order="7" role="constant"/>
        <ParameterDescription key="FunctionParameter_589" name="kmBPG_ENO" order="8" role="constant"/>
        <ParameterDescription key="FunctionParameter_590" name="kmPEP_ENO" order="9" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_74" name="function_4_PYK" type="UserDefined" reversible="false">
      <Expression>
        FBP/(FBP+kaFBP_PYK)*(kiPint_PYK^nPYK/(Pint^nPYK+kiPint_PYK^nPYK))*Vmax_PYK*(ADP/kmADP_PYK)*(PEP/kmPEP_PYK)/((1+ADP/kmADP_PYK)*(1+PEP/kmPEP_PYK)+(1+ATP/kmATP_PYK)*(1+PYR/kmPYR_PYK)-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_605" name="ADP" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_606" name="ATP" order="1" role="product"/>
        <ParameterDescription key="FunctionParameter_607" name="FBP" order="2" role="modifier"/>
        <ParameterDescription key="FunctionParameter_608" name="PEP" order="3" role="substrate"/>
        <ParameterDescription key="FunctionParameter_609" name="PYR" order="4" role="product"/>
        <ParameterDescription key="FunctionParameter_610" name="Pint" order="5" role="modifier"/>
        <ParameterDescription key="FunctionParameter_611" name="Vmax_PYK" order="6" role="constant"/>
        <ParameterDescription key="FunctionParameter_612" name="kaFBP_PYK" order="7" role="constant"/>
        <ParameterDescription key="FunctionParameter_613" name="kiPint_PYK" order="8" role="constant"/>
        <ParameterDescription key="FunctionParameter_614" name="kmADP_PYK" order="9" role="constant"/>
        <ParameterDescription key="FunctionParameter_615" name="kmATP_PYK" order="10" role="constant"/>
        <ParameterDescription key="FunctionParameter_616" name="kmPEP_PYK" order="11" role="constant"/>
        <ParameterDescription key="FunctionParameter_617" name="kmPYR_PYK" order="12" role="constant"/>
        <ParameterDescription key="FunctionParameter_618" name="nPYK" order="13" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_75" name="function_4_LDH" type="UserDefined" reversible="false">
      <Expression>
        FBP/(FBP+kaFBP_LDH)*(kiPint_LDH/(Pint+kiPint_LDH))*Vmax_LDH*(PYR/kmPYR_LDH)*(NADH/kmNADH_LDH)/((1+PYR/kmPYR_LDH)*(1+NADH/kmNADH_LDH)+(1+Lactate/kmLactate_LDH)*(1+NAD/kmNAD_LDH)-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_461" name="FBP" order="0" role="modifier"/>
        <ParameterDescription key="FunctionParameter_633" name="Lactate" order="1" role="product"/>
        <ParameterDescription key="FunctionParameter_634" name="NAD" order="2" role="product"/>
        <ParameterDescription key="FunctionParameter_635" name="NADH" order="3" role="substrate"/>
        <ParameterDescription key="FunctionParameter_636" name="PYR" order="4" role="substrate"/>
        <ParameterDescription key="FunctionParameter_637" name="Pint" order="5" role="modifier"/>
        <ParameterDescription key="FunctionParameter_638" name="Vmax_LDH" order="6" role="constant"/>
        <ParameterDescription key="FunctionParameter_639" name="kaFBP_LDH" order="7" role="constant"/>
        <ParameterDescription key="FunctionParameter_640" name="kiPint_LDH" order="8" role="constant"/>
        <ParameterDescription key="FunctionParameter_641" name="kmLactate_LDH" order="9" role="constant"/>
        <ParameterDescription key="FunctionParameter_642" name="kmNADH_LDH" order="10" role="constant"/>
        <ParameterDescription key="FunctionParameter_643" name="kmNAD_LDH" order="11" role="constant"/>
        <ParameterDescription key="FunctionParameter_644" name="kmPYR_LDH" order="12" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_76" name="function_4_PDH" type="UserDefined" reversible="true">
      <Expression>
        kiG3P_PDH/(G3P+kiG3P_PDH)*(Vmax_PDH*(PYR/kmPYR_PDH)*(CoA/KmCoA_PDH)-Vmax_PDH/Keq_PDH*(AcetCoA/kmPYR_PDH)*(Formate/KmCoA_PDH))/((1+PYR/kmPYR_PDH)*(1+CoA/KmCoA_PDH)+(1+AcetCoA/kmAcetCoA_PDH)*(1+Formate/kmFormate_PDH)-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_557" name="AcetCoA" order="0" role="product"/>
        <ParameterDescription key="FunctionParameter_658" name="CoA" order="1" role="substrate"/>
        <ParameterDescription key="FunctionParameter_659" name="Formate" order="2" role="product"/>
        <ParameterDescription key="FunctionParameter_660" name="G3P" order="3" role="modifier"/>
        <ParameterDescription key="FunctionParameter_661" name="Keq_PDH" order="4" role="constant"/>
        <ParameterDescription key="FunctionParameter_662" name="KmCoA_PDH" order="5" role="constant"/>
        <ParameterDescription key="FunctionParameter_663" name="PYR" order="6" role="substrate"/>
        <ParameterDescription key="FunctionParameter_664" name="Vmax_PDH" order="7" role="constant"/>
        <ParameterDescription key="FunctionParameter_665" name="kiG3P_PDH" order="8" role="constant"/>
        <ParameterDescription key="FunctionParameter_666" name="kmAcetCoA_PDH" order="9" role="constant"/>
        <ParameterDescription key="FunctionParameter_667" name="kmFormate_PDH" order="10" role="constant"/>
        <ParameterDescription key="FunctionParameter_668" name="kmPYR_PDH" order="11" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_77" name="function_4_AE" type="UserDefined" reversible="false">
      <Expression>
        kiATP_AE/(ATP+kiATP_AE)*Vmax_AE*(AcetCoA/kmAcetCoA_AE)*(NADH/kmNADH_AE)^2/((1+NADH/kmNADH_AE+(NADH/kmNADH_AE)^2)*(1+AcetCoA/kmAcetCoA_AE)+(1+Ethanol/kmEthanol_AE)*(1+CoA/kmCoA_AE)*(1+NAD/kmNAD_AE+(NAD/kmNAD_AE)^2)-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_682" name="ATP" order="0" role="modifier"/>
        <ParameterDescription key="FunctionParameter_683" name="AcetCoA" order="1" role="substrate"/>
        <ParameterDescription key="FunctionParameter_684" name="CoA" order="2" role="product"/>
        <ParameterDescription key="FunctionParameter_685" name="Ethanol" order="3" role="product"/>
        <ParameterDescription key="FunctionParameter_686" name="NAD" order="4" role="product"/>
        <ParameterDescription key="FunctionParameter_687" name="NADH" order="5" role="substrate"/>
        <ParameterDescription key="FunctionParameter_688" name="Vmax_AE" order="6" role="constant"/>
        <ParameterDescription key="FunctionParameter_689" name="kiATP_AE" order="7" role="constant"/>
        <ParameterDescription key="FunctionParameter_690" name="kmAcetCoA_AE" order="8" role="constant"/>
        <ParameterDescription key="FunctionParameter_691" name="kmCoA_AE" order="9" role="constant"/>
        <ParameterDescription key="FunctionParameter_692" name="kmEthanol_AE" order="10" role="constant"/>
        <ParameterDescription key="FunctionParameter_693" name="kmNADH_AE" order="11" role="constant"/>
        <ParameterDescription key="FunctionParameter_694" name="kmNAD_AE" order="12" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_78" name="function_4_AC" type="UserDefined" reversible="false">
      <Expression>
        Vmax_AC*(AcetCoA/kmAcetCoA_AC)*(ADP/kmADP_AC)/((1+AcetCoA/kmAcetCoA_AC)*(1+ADP/kmADP_AC)+(1+Acetate/kmAcetate_AC)*(1+ATP/kmATP_AC)*(1+CoA/kmCoA_AC)-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_558" name="ADP" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_603" name="ATP" order="1" role="product"/>
        <ParameterDescription key="FunctionParameter_708" name="AcetCoA" order="2" role="substrate"/>
        <ParameterDescription key="FunctionParameter_709" name="Acetate" order="3" role="product"/>
        <ParameterDescription key="FunctionParameter_710" name="CoA" order="4" role="product"/>
        <ParameterDescription key="FunctionParameter_711" name="Vmax_AC" order="5" role="constant"/>
        <ParameterDescription key="FunctionParameter_712" name="kmADP_AC" order="6" role="constant"/>
        <ParameterDescription key="FunctionParameter_713" name="kmATP_AC" order="7" role="constant"/>
        <ParameterDescription key="FunctionParameter_714" name="kmAcetCoA_AC" order="8" role="constant"/>
        <ParameterDescription key="FunctionParameter_715" name="kmAcetate_AC" order="9" role="constant"/>
        <ParameterDescription key="FunctionParameter_716" name="kmCoA_AC" order="10" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_79" name="function_4_PA" type="UserDefined" reversible="true">
      <Expression>
        (Vmax_PA*(PYR/kmPYR_PA)^2-Vmax_PA/Keq_PA*(Acetoin/kmPYR_PA))/(1+PYR/kmPYR_PA+(PYR/kmPYR_PA)^2+1+Acetoin/kmAcetoin_PA-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_602" name="Acetoin" order="0" role="product"/>
        <ParameterDescription key="FunctionParameter_523" name="Keq_PA" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_454" name="PYR" order="2" role="substrate"/>
        <ParameterDescription key="FunctionParameter_556" name="Vmax_PA" order="3" role="constant"/>
        <ParameterDescription key="FunctionParameter_604" name="kmAcetoin_PA" order="4" role="constant"/>
        <ParameterDescription key="FunctionParameter_728" name="kmPYR_PA" order="5" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_80" name="function_4_AB" type="UserDefined" reversible="true">
      <Expression>
        (Vmax_AB*(Acetoin/kmAcetoin_AB)*(NADH/kmNADH_AB)-Vmax_AB/Keq_AB*(Butanediol/kmAcetoin_AB)*(NAD/kmNADH_AB))/((1+Acetoin/kmAcetoin_AB)*(1+NADH/kmNADH_AB)+(1+Butanediol/kmButanediol_AB)*(1+NAD/kmNAD_AB)-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_739" name="Acetoin" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_740" name="Butanediol" order="1" role="product"/>
        <ParameterDescription key="FunctionParameter_741" name="Keq_AB" order="2" role="constant"/>
        <ParameterDescription key="FunctionParameter_742" name="NAD" order="3" role="product"/>
        <ParameterDescription key="FunctionParameter_743" name="NADH" order="4" role="substrate"/>
        <ParameterDescription key="FunctionParameter_744" name="Vmax_AB" order="5" role="constant"/>
        <ParameterDescription key="FunctionParameter_745" name="kmAcetoin_AB" order="6" role="constant"/>
        <ParameterDescription key="FunctionParameter_746" name="kmButanediol_AB" order="7" role="constant"/>
        <ParameterDescription key="FunctionParameter_747" name="kmNADH_AB" order="8" role="constant"/>
        <ParameterDescription key="FunctionParameter_748" name="kmNAD_AB" order="9" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_81" name="function_4_MPD" type="UserDefined" reversible="true">
      <Expression>
        kiF6P_MPD/(F6P+kiF6P_MPD)*(Vmax_MPD*(F6P/kmF6P_MPD)*(NADH/kmNADH_MPD)-Vmax_MPD/Keq_MPD*(Mannitol1Phosphate/kmF6P_MPD)*(NAD/kmNADH_MPD))/((1+F6P/kmF6P_MPD)*(1+NADH/kmNADH_MPD)+(1+Mannitol1Phosphate/kmMannitol1Phoshate_MPD)*(1+NAD/kmNAD_MPD)-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_760" name="F6P" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_761" name="Keq_MPD" order="1" role="constant"/>
        <ParameterDescription key="FunctionParameter_762" name="Mannitol1Phosphate" order="2" role="product"/>
        <ParameterDescription key="FunctionParameter_763" name="NAD" order="3" role="product"/>
        <ParameterDescription key="FunctionParameter_764" name="NADH" order="4" role="substrate"/>
        <ParameterDescription key="FunctionParameter_765" name="Vmax_MPD" order="5" role="constant"/>
        <ParameterDescription key="FunctionParameter_766" name="kiF6P_MPD" order="6" role="constant"/>
        <ParameterDescription key="FunctionParameter_767" name="kmF6P_MPD" order="7" role="constant"/>
        <ParameterDescription key="FunctionParameter_768" name="kmMannitol1Phoshate_MPD" order="8" role="constant"/>
        <ParameterDescription key="FunctionParameter_769" name="kmNADH_MPD" order="9" role="constant"/>
        <ParameterDescription key="FunctionParameter_770" name="kmNAD_MPD" order="10" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_82" name="function_4_MP" type="UserDefined" reversible="false">
      <Expression>
        Vmax_MP*(Mannitol1Phosphate/kmMannitol1Phosphate_MP)/(1+Mannitol1Phosphate/kmMannitol1Phosphate_MP+1+Mannitol/kmMannitol_MP-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_737" name="Mannitol" order="0" role="product"/>
        <ParameterDescription key="FunctionParameter_601" name="Mannitol1Phosphate" order="1" role="substrate"/>
        <ParameterDescription key="FunctionParameter_735" name="Vmax_MP" order="2" role="constant"/>
        <ParameterDescription key="FunctionParameter_553" name="kmMannitol1Phosphate_MP" order="3" role="constant"/>
        <ParameterDescription key="FunctionParameter_736" name="kmMannitol_MP" order="4" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_83" name="function_4_PTS_Man" type="UserDefined" reversible="false">
      <Expression>
        Vmax_PTS_Man*(Mannitol_Ext/kmMannitolExt_PTS_Man)*(PEP/kmPEP_PTS_Man)/((1+Mannitol_Ext/kmMannitolExt_PTS_Man)*(1+PEP/kmPEP_PTS_Man)+(1+Mannitol1Phosphate/kmMannitol1Phosphate_PTS_Man)*(1+PYR/kmPYR_PTS_Man)-1)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_790" name="Mannitol1Phosphate" order="0" role="product"/>
        <ParameterDescription key="FunctionParameter_791" name="Mannitol_Ext" order="1" role="substrate"/>
        <ParameterDescription key="FunctionParameter_792" name="PEP" order="2" role="substrate"/>
        <ParameterDescription key="FunctionParameter_793" name="PYR" order="3" role="product"/>
        <ParameterDescription key="FunctionParameter_794" name="Vmax_PTS_Man" order="4" role="constant"/>
        <ParameterDescription key="FunctionParameter_795" name="kmMannitol1Phosphate_PTS_Man" order="5" role="constant"/>
        <ParameterDescription key="FunctionParameter_796" name="kmMannitolExt_PTS_Man" order="6" role="constant"/>
        <ParameterDescription key="FunctionParameter_797" name="kmPEP_PTS_Man" order="7" role="constant"/>
        <ParameterDescription key="FunctionParameter_798" name="kmPYR_PTS_Man" order="8" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_84" name="function_4_Acetoin_transp" type="UserDefined" reversible="false">
      <Expression>
        Vmax_Acetoin_transp*(Acetoin/kmAcetoin_Acetoin_transp)/(1+Acetoin/kmAcetoin_Acetoin_transp+Acetoin_Ext/kmAcetoin_Ext_Acetoin_transp)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_788" name="Acetoin" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_525" name="Acetoin_Ext" order="1" role="product"/>
        <ParameterDescription key="FunctionParameter_681" name="Vmax_Acetoin_transp" order="2" role="constant"/>
        <ParameterDescription key="FunctionParameter_786" name="kmAcetoin_Acetoin_transp" order="3" role="constant"/>
        <ParameterDescription key="FunctionParameter_808" name="kmAcetoin_Ext_Acetoin_transp" order="4" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_85" name="function_4_Mannitol_transp" type="UserDefined" reversible="false">
      <Expression>
        Vmax_Mannitol_transp*(Mannitol/kmMannitol_Mannitol_transp)/(1+Mannitol/kmMannitol_Mannitol_transp+Mannitol_Ext/kmMannitol_Ext_Mannitol_transp)
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_814" name="Mannitol" order="0" role="substrate"/>
        <ParameterDescription key="FunctionParameter_815" name="Mannitol_Ext" order="1" role="product"/>
        <ParameterDescription key="FunctionParameter_816" name="Vmax_Mannitol_transp" order="2" role="constant"/>
        <ParameterDescription key="FunctionParameter_817" name="kmMannitol_Ext_Mannitol_transp" order="3" role="constant"/>
        <ParameterDescription key="FunctionParameter_818" name="kmMannitol_Mannitol_transp" order="4" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
    <Function key="Function_86" name="function_4_FBPase" type="UserDefined" reversible="false">
      <Expression>
        Vmax_FBPase*(FBP/kmFBP_FBPase)/(FBP/kmFBP_FBPase+(1+F6P/kmF6P_FBPase)*(1+Pint/kmPint_FBPase))
      </Expression>
      <ListOfParameterDescriptions>
        <ParameterDescription key="FunctionParameter_826" name="F6P" order="0" role="product"/>
        <ParameterDescription key="FunctionParameter_827" name="FBP" order="1" role="substrate"/>
        <ParameterDescription key="FunctionParameter_828" name="Pint" order="2" role="product"/>
        <ParameterDescription key="FunctionParameter_829" name="Vmax_FBPase" order="3" role="constant"/>
        <ParameterDescription key="FunctionParameter_830" name="kmF6P_FBPase" order="4" role="constant"/>
        <ParameterDescription key="FunctionParameter_831" name="kmFBP_FBPase" order="5" role="constant"/>
        <ParameterDescription key="FunctionParameter_832" name="kmPint_FBPase" order="6" role="constant"/>
      </ListOfParameterDescriptions>
    </Function>
  </ListOfFunctions>
  <Model key="Model_0" name="Computational Model of L. lactis Metabolism" simulationType="time" timeUnit="s" volumeUnit="l" areaUnit="m²" lengthUnit="m" quantityUnit="mmol" type="deterministic" avogadroConstant="6.02214179e+023">
    <MiriamAnnotation>
<rdf:RDF
   xmlns:dcterms="http://purl.org/dc/terms/"
   xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Model_0">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2012-06-14T23:28:10Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
    <dcterms:modified>
      <rdf:Description>
        <dcterms:W3CDTF></dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:modified>
  </rdf:Description>
</rdf:RDF>

    </MiriamAnnotation>
    <Comment>
      
  &lt;body xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;
    &lt;p&gt;
      &lt;b&gt;Computational Model of &lt;i&gt;L. lactis&lt;/i&gt; Metabolism&lt;/b&gt; created by Rafael Costa. INESC-ID, Lisboa, Portugal.&lt;/p&gt;
      &lt;p&gt;Published in Rafael S. Costa, Andras Hartmann, Paula Gaspar, Ana R. Neves and Susana Vinga (2014),
An extended dynamic model of &lt;i&gt;Lactococcus lactis&lt;/i&gt; metabolism for mannitol and 2,3-butanediol production. &lt;i&gt;Molecular BioSystems&lt;/i&gt;
      &lt;a href=&quot;http://pubs.rsc.org/en/content/articlelanding/2014/mb/c3mb70265k#!divAbstract&quot;&gt;10.1039/C3MB70265K &lt;/a&gt;
    &lt;/p&gt;
  &lt;/body&gt;

    </Comment>
    <ListOfCompartments>
      <Compartment key="Compartment_0" name="default" simulationType="fixed" dimensionality="3">
      </Compartment>
      <Compartment key="Compartment_1" name="Intracellular" simulationType="fixed" dimensionality="3">
      </Compartment>
      <Compartment key="Compartment_2" name="Extracellular" simulationType="fixed" dimensionality="3">
      </Compartment>
    </ListOfCompartments>
    <ListOfMetabolites>
      <Metabolite key="Metabolite_0" name="G6P" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_1" name="ATP" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_2" name="ADP" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_3" name="Pint" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_4" name="F6P" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_5" name="FBP" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_6" name="G3P" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_7" name="BPG" simulationType="reactions" compartment="Compartment_1">
        <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Metabolite_7">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2012-06-14T23:44:30Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
      </Metabolite>
      <Metabolite key="Metabolite_8" name="PEP" simulationType="reactions" compartment="Compartment_1">
        <MiriamAnnotation>
<rdf:RDF xmlns:dcterms="http://purl.org/dc/terms/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="#Metabolite_8">
    <dcterms:created>
      <rdf:Description>
        <dcterms:W3CDTF>2012-06-14T23:44:17Z</dcterms:W3CDTF>
      </rdf:Description>
    </dcterms:created>
  </rdf:Description>
</rdf:RDF>
        </MiriamAnnotation>
      </Metabolite>
      <Metabolite key="Metabolite_9" name="NAD" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_10" name="NADH" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_11" name="PYR" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_12" name="AcetCoA" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_13" name="Acetoin" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_14" name="Mannitol" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_15" name="Mannitol1Phosphate" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_16" name="CoA" simulationType="reactions" compartment="Compartment_1">
      </Metabolite>
      <Metabolite key="Metabolite_17" name="Pext" simulationType="reactions" compartment="Compartment_2">
      </Metabolite>
      <Metabolite key="Metabolite_18" name="Lactate" simulationType="reactions" compartment="Compartment_2">
      </Metabolite>
      <Metabolite key="Metabolite_19" name="Ethanol" simulationType="reactions" compartment="Compartment_2">
      </Metabolite>
      <Metabolite key="Metabolite_20" name="Acetate" simulationType="reactions" compartment="Compartment_2">
      </Metabolite>
      <Metabolite key="Metabolite_21" name="Butanediol" simulationType="reactions" compartment="Compartment_2">
      </Metabolite>
      <Metabolite key="Metabolite_22" name="Glucose" simulationType="reactions" compartment="Compartment_2">
      </Metabolite>
      <Metabolite key="Metabolite_23" name="Acetoin_Ext" simulationType="reactions" compartment="Compartment_2">
      </Metabolite>
      <Metabolite key="Metabolite_24" name="Mannitol_Ext" simulationType="reactions" compartment="Compartment_2">
      </Metabolite>
      <Metabolite key="Metabolite_25" name="Formate" simulationType="reactions" compartment="Compartment_2">
      </Metabolite>
    </ListOfMetabolites>
    <ListOfReactions>
      <Reaction key="Reaction_0" name="PTS_Glc" reversible="false">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_22" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_8" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_0" stoichiometry="1"/>
          <Product metabolite="Metabolite_11" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfModifiers>
          <Modifier metabolite="Metabolite_5" stoichiometry="1"/>
          <Modifier metabolite="Metabolite_3" stoichiometry="1"/>
        </ListOfModifiers>
        <ListOfConstants>
          <Constant key="Parameter_1639" name="Vmax_PTS_Glc" value="3.71082"/>
          <Constant key="Parameter_1640" name="kaPint_PTS_Glc" value="0.070909"/>
          <Constant key="Parameter_1641" name="kiFBP_PTS_Glc" value="1.16937"/>
          <Constant key="Parameter_1644" name="kmG6P_PTS_Glc" value="0.284871"/>
          <Constant key="Parameter_1643" name="kmGlucose_PTS_Glc" value="0.0485045"/>
          <Constant key="Parameter_1645" name="kmPEP_PTS_Glc" value="0.305604"/>
          <Constant key="Parameter_1642" name="kmPYR_PTS_Glc" value="1.95993"/>
        </ListOfConstants>
        <KineticLaw function="Function_66">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_464">
              <SourceParameter reference="Metabolite_5"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_465">
              <SourceParameter reference="Metabolite_0"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_466">
              <SourceParameter reference="Metabolite_22"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_467">
              <SourceParameter reference="Metabolite_8"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_468">
              <SourceParameter reference="Metabolite_11"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_469">
              <SourceParameter reference="Metabolite_3"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_470">
              <SourceParameter reference="Parameter_1639"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_471">
              <SourceParameter reference="Parameter_1640"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_472">
              <SourceParameter reference="Parameter_1641"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_473">
              <SourceParameter reference="Parameter_1644"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_474">
              <SourceParameter reference="Parameter_1643"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_475">
              <SourceParameter reference="Parameter_1645"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_476">
              <SourceParameter reference="Parameter_1642"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_1" name="ATPase" reversible="false">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_1" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_2" stoichiometry="1"/>
          <Product metabolite="Metabolite_3" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1646" name="Vmax_ATPase" value="3.2901"/>
          <Constant key="Parameter_1647" name="kmATP_ATPase" value="4.34159"/>
          <Constant key="Parameter_1648" name="nATPase" value="3"/>
        </ListOfConstants>
        <KineticLaw function="Function_67">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_453">
              <SourceParameter reference="Metabolite_1"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_452">
              <SourceParameter reference="Parameter_1646"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_455">
              <SourceParameter reference="Parameter_1647"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_451">
              <SourceParameter reference="Parameter_1648"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_2" name="P_transp" reversible="false">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_17" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_1" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_3" stoichiometry="2"/>
          <Product metabolite="Metabolite_2" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfModifiers>
          <Modifier metabolite="Metabolite_3" stoichiometry="1"/>
        </ListOfModifiers>
        <ListOfConstants>
          <Constant key="Parameter_1649" name="Vmax_Ptransport" value="3.59588"/>
          <Constant key="Parameter_1650" name="kiPint_Ptransport" value="0.561093"/>
          <Constant key="Parameter_1651" name="kmADP_Ptransport" value="0.192278"/>
          <Constant key="Parameter_1652" name="kmATP_Ptransport" value="0.523288"/>
          <Constant key="Parameter_1653" name="kmPext_Ptransport" value="0.749898"/>
          <Constant key="Parameter_1654" name="kmPint_Ptransport" value="0.30336"/>
        </ListOfConstants>
        <KineticLaw function="Function_68">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_495">
              <SourceParameter reference="Metabolite_2"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_496">
              <SourceParameter reference="Metabolite_1"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_497">
              <SourceParameter reference="Metabolite_17"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_498">
              <SourceParameter reference="Metabolite_3"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_499">
              <SourceParameter reference="Parameter_1649"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_500">
              <SourceParameter reference="Parameter_1650"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_501">
              <SourceParameter reference="Parameter_1651"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_502">
              <SourceParameter reference="Parameter_1652"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_503">
              <SourceParameter reference="Parameter_1653"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_504">
              <SourceParameter reference="Parameter_1654"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_3" name="PGI" reversible="true">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_0" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_4" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1655" name="Keq_PGI" value="0.43"/>
          <Constant key="Parameter_1656" name="Vmax_PGI" value="21.681"/>
          <Constant key="Parameter_1657" name="kmF6P_PGI" value="3.13894"/>
          <Constant key="Parameter_1658" name="kmG6P_PGI" value="0.199409"/>
        </ListOfConstants>
        <KineticLaw function="Function_69">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_457">
              <SourceParameter reference="Metabolite_4"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_490">
              <SourceParameter reference="Metabolite_0"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_459">
              <SourceParameter reference="Parameter_1655"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_493">
              <SourceParameter reference="Parameter_1656"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_515">
              <SourceParameter reference="Parameter_1657"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_516">
              <SourceParameter reference="Parameter_1658"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_4" name="PFK" reversible="false">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_4" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_1" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_5" stoichiometry="1"/>
          <Product metabolite="Metabolite_2" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1659" name="Vmax_PFK" value="18.3577"/>
          <Constant key="Parameter_1660" name="kmADP_PFK" value="10.7357"/>
          <Constant key="Parameter_1661" name="kmATP_PFK" value="0.0616607"/>
          <Constant key="Parameter_1664" name="kmF6P_PFK" value="1.01973"/>
          <Constant key="Parameter_1663" name="kmFBP_PFK" value="86.8048"/>
        </ListOfConstants>
        <KineticLaw function="Function_70">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_526">
              <SourceParameter reference="Metabolite_2"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_527">
              <SourceParameter reference="Metabolite_1"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_528">
              <SourceParameter reference="Metabolite_4"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_529">
              <SourceParameter reference="Metabolite_5"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_530">
              <SourceParameter reference="Parameter_1659"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_531">
              <SourceParameter reference="Parameter_1660"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_532">
              <SourceParameter reference="Parameter_1661"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_533">
              <SourceParameter reference="Parameter_1664"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_534">
              <SourceParameter reference="Parameter_1663"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_5" name="FBA" reversible="true">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_5" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_6" stoichiometry="2"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1662" name="Keq_FBA" value="0.056"/>
          <Constant key="Parameter_1665" name="Vmax_FBA" value="56.1311"/>
          <Constant key="Parameter_1666" name="kmFBP_FBA" value="0.300745"/>
          <Constant key="Parameter_1669" name="kmG3P_FBA" value="10.1058"/>
        </ListOfConstants>
        <KineticLaw function="Function_71">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_463">
              <SourceParameter reference="Metabolite_5"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_494">
              <SourceParameter reference="Metabolite_6"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_524">
              <SourceParameter reference="Parameter_1662"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_544">
              <SourceParameter reference="Parameter_1665"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_545">
              <SourceParameter reference="Parameter_1666"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_546">
              <SourceParameter reference="Parameter_1669"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_6" name="GAPDH" reversible="true">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_6" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_3" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_9" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_7" stoichiometry="1"/>
          <Product metabolite="Metabolite_10" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1668" name="Keq_GAPDH" value="0.0007"/>
          <Constant key="Parameter_1667" name="Vmax_GAPDH" value="30.0058"/>
          <Constant key="Parameter_1670" name="kmBPG_GAPDH" value="0.0481603"/>
          <Constant key="Parameter_1671" name="kmG3P_GAPDH" value="0.181788"/>
          <Constant key="Parameter_1672" name="kmNADH_GAPDH" value="0.643019"/>
          <Constant key="Parameter_1673" name="kmNAD_GAPDH" value="0.0477445"/>
          <Constant key="Parameter_1674" name="kmPint_GAPDH" value="6.75302"/>
        </ListOfConstants>
        <KineticLaw function="Function_72">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_559">
              <SourceParameter reference="Metabolite_7"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_560">
              <SourceParameter reference="Metabolite_6"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_561">
              <SourceParameter reference="Parameter_1668"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_562">
              <SourceParameter reference="Metabolite_9"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_563">
              <SourceParameter reference="Metabolite_10"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_564">
              <SourceParameter reference="Metabolite_3"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_565">
              <SourceParameter reference="Parameter_1667"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_566">
              <SourceParameter reference="Parameter_1670"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_567">
              <SourceParameter reference="Parameter_1671"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_568">
              <SourceParameter reference="Parameter_1672"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_569">
              <SourceParameter reference="Parameter_1673"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_570">
              <SourceParameter reference="Parameter_1674"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_7" name="ENO" reversible="true">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_7" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_2" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_8" stoichiometry="1"/>
          <Product metabolite="Metabolite_1" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1675" name="Keq_ENO" value="27.55"/>
          <Constant key="Parameter_1676" name="Vmax_ENO" value="29.132"/>
          <Constant key="Parameter_1677" name="kmADP_ENO" value="0.413195"/>
          <Constant key="Parameter_1678" name="kmATP_ENO" value="0.748238"/>
          <Constant key="Parameter_1679" name="kmBPG_ENO" value="0.0241572"/>
          <Constant key="Parameter_1680" name="kmPEP_ENO" value="1.38899"/>
        </ListOfConstants>
        <KineticLaw function="Function_73">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_491">
              <SourceParameter reference="Metabolite_2"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_555">
              <SourceParameter reference="Metabolite_1"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_583">
              <SourceParameter reference="Metabolite_7"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_584">
              <SourceParameter reference="Parameter_1675"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_585">
              <SourceParameter reference="Metabolite_8"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_586">
              <SourceParameter reference="Parameter_1676"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_587">
              <SourceParameter reference="Parameter_1677"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_588">
              <SourceParameter reference="Parameter_1678"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_589">
              <SourceParameter reference="Parameter_1679"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_590">
              <SourceParameter reference="Parameter_1680"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_8" name="PYK" reversible="false">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_8" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_2" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_11" stoichiometry="1"/>
          <Product metabolite="Metabolite_1" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfModifiers>
          <Modifier metabolite="Metabolite_5" stoichiometry="1"/>
          <Modifier metabolite="Metabolite_3" stoichiometry="1"/>
        </ListOfModifiers>
        <ListOfConstants>
          <Constant key="Parameter_1681" name="Vmax_PYK" value="2.22404"/>
          <Constant key="Parameter_1682" name="kaFBP_PYK" value="0.0388651"/>
          <Constant key="Parameter_1683" name="kiPint_PYK" value="3.70071"/>
          <Constant key="Parameter_1684" name="kmADP_PYK" value="3.07711"/>
          <Constant key="Parameter_1685" name="kmATP_PYK" value="29.6028"/>
          <Constant key="Parameter_1686" name="kmPEP_PYK" value="0.330583"/>
          <Constant key="Parameter_1687" name="kmPYR_PYK" value="96.4227"/>
          <Constant key="Parameter_1688" name="nPYK" value="3"/>
        </ListOfConstants>
        <KineticLaw function="Function_74">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_605">
              <SourceParameter reference="Metabolite_2"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_606">
              <SourceParameter reference="Metabolite_1"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_607">
              <SourceParameter reference="Metabolite_5"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_608">
              <SourceParameter reference="Metabolite_8"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_609">
              <SourceParameter reference="Metabolite_11"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_610">
              <SourceParameter reference="Metabolite_3"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_611">
              <SourceParameter reference="Parameter_1681"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_612">
              <SourceParameter reference="Parameter_1682"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_613">
              <SourceParameter reference="Parameter_1683"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_614">
              <SourceParameter reference="Parameter_1684"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_615">
              <SourceParameter reference="Parameter_1685"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_616">
              <SourceParameter reference="Parameter_1686"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_617">
              <SourceParameter reference="Parameter_1687"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_618">
              <SourceParameter reference="Parameter_1688"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_9" name="LDH" reversible="false">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_11" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_10" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_18" stoichiometry="1"/>
          <Product metabolite="Metabolite_9" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfModifiers>
          <Modifier metabolite="Metabolite_5" stoichiometry="1"/>
          <Modifier metabolite="Metabolite_3" stoichiometry="1"/>
        </ListOfModifiers>
        <ListOfConstants>
          <Constant key="Parameter_1689" name="Vmax_LDH" value="566.598"/>
          <Constant key="Parameter_1690" name="kaFBP_LDH" value="0.0184011"/>
          <Constant key="Parameter_1691" name="kiPint_LDH" value="0.0676829"/>
          <Constant key="Parameter_1692" name="kmLactate_LDH" value="94.1203"/>
          <Constant key="Parameter_1693" name="kmNADH_LDH" value="0.144443"/>
          <Constant key="Parameter_1694" name="kmNAD_LDH" value="3.08447"/>
          <Constant key="Parameter_1695" name="kmPYR_LDH" value="0.01"/>
        </ListOfConstants>
        <KineticLaw function="Function_75">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_461">
              <SourceParameter reference="Metabolite_5"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_633">
              <SourceParameter reference="Metabolite_18"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_634">
              <SourceParameter reference="Metabolite_9"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_635">
              <SourceParameter reference="Metabolite_10"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_636">
              <SourceParameter reference="Metabolite_11"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_637">
              <SourceParameter reference="Metabolite_3"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_638">
              <SourceParameter reference="Parameter_1689"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_639">
              <SourceParameter reference="Parameter_1690"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_640">
              <SourceParameter reference="Parameter_1691"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_641">
              <SourceParameter reference="Parameter_1692"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_642">
              <SourceParameter reference="Parameter_1693"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_643">
              <SourceParameter reference="Parameter_1694"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_644">
              <SourceParameter reference="Parameter_1695"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_10" name="PDH" reversible="true">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_11" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_16" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_12" stoichiometry="1"/>
          <Product metabolite="Metabolite_25" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfModifiers>
          <Modifier metabolite="Metabolite_6" stoichiometry="1"/>
        </ListOfModifiers>
        <ListOfConstants>
          <Constant key="Parameter_1696" name="Keq_PDH" value="650"/>
          <Constant key="Parameter_1697" name="KmCoA_PDH" value="0.124066"/>
          <Constant key="Parameter_1710" name="Vmax_PDH" value="0.00230934"/>
          <Constant key="Parameter_1711" name="kiG3P_PDH" value="0.511288"/>
          <Constant key="Parameter_1637" name="kmAcetCoA_PDH" value="7.34319"/>
          <Constant key="Parameter_1636" name="kmFormate_PDH" value="54.2693"/>
          <Constant key="Parameter_1635" name="kmPYR_PDH" value="5.77662"/>
        </ListOfConstants>
        <KineticLaw function="Function_76">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_557">
              <SourceParameter reference="Metabolite_12"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_658">
              <SourceParameter reference="Metabolite_16"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_659">
              <SourceParameter reference="Metabolite_25"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_660">
              <SourceParameter reference="Metabolite_6"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_661">
              <SourceParameter reference="Parameter_1696"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_662">
              <SourceParameter reference="Parameter_1697"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_663">
              <SourceParameter reference="Metabolite_11"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_664">
              <SourceParameter reference="Parameter_1710"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_665">
              <SourceParameter reference="Parameter_1711"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_666">
              <SourceParameter reference="Parameter_1637"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_667">
              <SourceParameter reference="Parameter_1636"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_668">
              <SourceParameter reference="Parameter_1635"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_11" name="AE" reversible="false">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_12" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_10" stoichiometry="2"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_19" stoichiometry="1"/>
          <Product metabolite="Metabolite_9" stoichiometry="2"/>
          <Product metabolite="Metabolite_16" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfModifiers>
          <Modifier metabolite="Metabolite_1" stoichiometry="1"/>
        </ListOfModifiers>
        <ListOfConstants>
          <Constant key="Parameter_1634" name="Vmax_AE" value="2.11844"/>
          <Constant key="Parameter_1633" name="kiATP_AE" value="6.28119"/>
          <Constant key="Parameter_1632" name="kmAcetCoA_AE" value="7.38021"/>
          <Constant key="Parameter_1631" name="kmCoA_AE" value="0.091813"/>
          <Constant key="Parameter_1630" name="kmEthanol_AE" value="2.28106"/>
          <Constant key="Parameter_1629" name="kmNADH_AE" value="0.43127"/>
          <Constant key="Parameter_1628" name="kmNAD_AE" value="1.31442"/>
        </ListOfConstants>
        <KineticLaw function="Function_77">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_682">
              <SourceParameter reference="Metabolite_1"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_683">
              <SourceParameter reference="Metabolite_12"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_684">
              <SourceParameter reference="Metabolite_16"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_685">
              <SourceParameter reference="Metabolite_19"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_686">
              <SourceParameter reference="Metabolite_9"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_687">
              <SourceParameter reference="Metabolite_10"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_688">
              <SourceParameter reference="Parameter_1634"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_689">
              <SourceParameter reference="Parameter_1633"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_690">
              <SourceParameter reference="Parameter_1632"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_691">
              <SourceParameter reference="Parameter_1631"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_692">
              <SourceParameter reference="Parameter_1630"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_693">
              <SourceParameter reference="Parameter_1629"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_694">
              <SourceParameter reference="Parameter_1628"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_12" name="AC" reversible="false">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_12" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_2" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_20" stoichiometry="1"/>
          <Product metabolite="Metabolite_1" stoichiometry="1"/>
          <Product metabolite="Metabolite_16" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1712" name="Vmax_AC" value="3.83918"/>
          <Constant key="Parameter_1713" name="kmADP_AC" value="1.17242"/>
          <Constant key="Parameter_1553" name="kmATP_AC" value="14.1556"/>
          <Constant key="Parameter_1552" name="kmAcetCoA_AC" value="0.55824"/>
          <Constant key="Parameter_1551" name="kmAcetate_AC" value="0.552221"/>
          <Constant key="Parameter_1550" name="kmCoA_AC" value="0.173388"/>
        </ListOfConstants>
        <KineticLaw function="Function_78">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_558">
              <SourceParameter reference="Metabolite_2"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_603">
              <SourceParameter reference="Metabolite_1"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_708">
              <SourceParameter reference="Metabolite_12"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_709">
              <SourceParameter reference="Metabolite_20"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_710">
              <SourceParameter reference="Metabolite_16"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_711">
              <SourceParameter reference="Parameter_1712"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_712">
              <SourceParameter reference="Parameter_1713"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_713">
              <SourceParameter reference="Parameter_1553"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_714">
              <SourceParameter reference="Parameter_1552"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_715">
              <SourceParameter reference="Parameter_1551"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_716">
              <SourceParameter reference="Parameter_1550"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_13" name="PA" reversible="true">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_11" stoichiometry="2"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_13" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1549" name="Keq_PA" value="900000"/>
          <Constant key="Parameter_1548" name="Vmax_PA" value="0.354581"/>
          <Constant key="Parameter_1547" name="kmAcetoin_PA" value="0.0495418"/>
          <Constant key="Parameter_1546" name="kmPYR_PA" value="0.262819"/>
        </ListOfConstants>
        <KineticLaw function="Function_79">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_602">
              <SourceParameter reference="Metabolite_13"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_523">
              <SourceParameter reference="Parameter_1549"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_454">
              <SourceParameter reference="Metabolite_11"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_556">
              <SourceParameter reference="Parameter_1548"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_604">
              <SourceParameter reference="Parameter_1547"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_728">
              <SourceParameter reference="Parameter_1546"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_14" name="AB" reversible="true">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_13" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_10" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_21" stoichiometry="1"/>
          <Product metabolite="Metabolite_9" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1545" name="Keq_AB" value="1400"/>
          <Constant key="Parameter_1544" name="Vmax_AB" value="2.28578"/>
          <Constant key="Parameter_1543" name="kmAcetoin_AB" value="5.62373"/>
          <Constant key="Parameter_1542" name="kmButanediol_AB" value="1.80684"/>
          <Constant key="Parameter_1541" name="kmNADH_AB" value="3.54858"/>
          <Constant key="Parameter_1540" name="kmNAD_AB" value="1.29567"/>
        </ListOfConstants>
        <KineticLaw function="Function_80">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_739">
              <SourceParameter reference="Metabolite_13"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_740">
              <SourceParameter reference="Metabolite_21"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_741">
              <SourceParameter reference="Parameter_1545"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_742">
              <SourceParameter reference="Metabolite_9"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_743">
              <SourceParameter reference="Metabolite_10"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_744">
              <SourceParameter reference="Parameter_1544"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_745">
              <SourceParameter reference="Parameter_1543"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_746">
              <SourceParameter reference="Parameter_1542"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_747">
              <SourceParameter reference="Parameter_1541"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_748">
              <SourceParameter reference="Parameter_1540"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_15" name="MPD" reversible="true">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_4" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_10" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_15" stoichiometry="1"/>
          <Product metabolite="Metabolite_9" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfModifiers>
          <Modifier metabolite="Metabolite_4" stoichiometry="1"/>
        </ListOfModifiers>
        <ListOfConstants>
          <Constant key="Parameter_1539" name="Keq_MPD" value="200"/>
          <Constant key="Parameter_1538" name="Vmax_MPD" value="1.32695"/>
          <Constant key="Parameter_1537" name="kiF6P_MPD" value="22.0284"/>
          <Constant key="Parameter_1536" name="kmF6P_MPD" value="0.321372"/>
          <Constant key="Parameter_1535" name="kmMannitol1Phoshate_MPD" value="0.0891203"/>
          <Constant key="Parameter_1534" name="kmNADH_MPD" value="0.0303446"/>
          <Constant key="Parameter_1533" name="kmNAD_MPD" value="0.373149"/>
        </ListOfConstants>
        <KineticLaw function="Function_81">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_760">
              <SourceParameter reference="Metabolite_4"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_761">
              <SourceParameter reference="Parameter_1539"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_762">
              <SourceParameter reference="Metabolite_15"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_763">
              <SourceParameter reference="Metabolite_9"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_764">
              <SourceParameter reference="Metabolite_10"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_765">
              <SourceParameter reference="Parameter_1538"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_766">
              <SourceParameter reference="Parameter_1537"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_767">
              <SourceParameter reference="Parameter_1536"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_768">
              <SourceParameter reference="Parameter_1535"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_769">
              <SourceParameter reference="Parameter_1534"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_770">
              <SourceParameter reference="Parameter_1533"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_16" name="MP" reversible="false">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_15" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_14" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1532" name="Vmax_MP" value="3.48563"/>
          <Constant key="Parameter_1531" name="kmMannitol1Phosphate_MP" value="3.51571"/>
          <Constant key="Parameter_1530" name="kmMannitol_MP" value="0.238849"/>
        </ListOfConstants>
        <KineticLaw function="Function_82">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_737">
              <SourceParameter reference="Metabolite_14"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_601">
              <SourceParameter reference="Metabolite_15"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_735">
              <SourceParameter reference="Parameter_1532"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_553">
              <SourceParameter reference="Parameter_1531"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_736">
              <SourceParameter reference="Parameter_1530"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_17" name="PTS_Man" reversible="false">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_24" stoichiometry="1"/>
          <Substrate metabolite="Metabolite_8" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_15" stoichiometry="1"/>
          <Product metabolite="Metabolite_11" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1529" name="Vmax_PTS_Man" value="4.44903"/>
          <Constant key="Parameter_1528" name="kmMannitol1Phosphate_PTS_Man" value="0.362571"/>
          <Constant key="Parameter_1527" name="kmMannitolExt_PTS_Man" value="0.0127321"/>
          <Constant key="Parameter_1526" name="kmPEP_PTS_Man" value="2.20816"/>
          <Constant key="Parameter_1525" name="kmPYR_PTS_Man" value="0.344134"/>
        </ListOfConstants>
        <KineticLaw function="Function_83">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_790">
              <SourceParameter reference="Metabolite_15"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_791">
              <SourceParameter reference="Metabolite_24"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_792">
              <SourceParameter reference="Metabolite_8"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_793">
              <SourceParameter reference="Metabolite_11"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_794">
              <SourceParameter reference="Parameter_1529"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_795">
              <SourceParameter reference="Parameter_1528"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_796">
              <SourceParameter reference="Parameter_1527"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_797">
              <SourceParameter reference="Parameter_1526"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_798">
              <SourceParameter reference="Parameter_1525"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_18" name="Acetoin_transp" reversible="false">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_13" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_23" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1524" name="Vmax_Acetoin_transp" value="1.60066"/>
          <Constant key="Parameter_1523" name="kmAcetoin_Acetoin_transp" value="1.89255"/>
          <Constant key="Parameter_1522" name="kmAcetoin_Ext_Acetoin_transp" value="7.05248"/>
        </ListOfConstants>
        <KineticLaw function="Function_84">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_788">
              <SourceParameter reference="Metabolite_13"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_525">
              <SourceParameter reference="Metabolite_23"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_681">
              <SourceParameter reference="Parameter_1524"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_786">
              <SourceParameter reference="Parameter_1523"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_808">
              <SourceParameter reference="Parameter_1522"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_19" name="Mannitol_transp" reversible="false">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_14" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_24" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1521" name="Vmax_Mannitol_transp" value="1.62459"/>
          <Constant key="Parameter_1520" name="kmMannitol_Ext_Mannitol_transp" value="0.940662"/>
          <Constant key="Parameter_1519" name="kmMannitol_Mannitol_transp" value="0.0223502"/>
        </ListOfConstants>
        <KineticLaw function="Function_85">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_814">
              <SourceParameter reference="Metabolite_14"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_815">
              <SourceParameter reference="Metabolite_24"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_816">
              <SourceParameter reference="Parameter_1521"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_817">
              <SourceParameter reference="Parameter_1520"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_818">
              <SourceParameter reference="Parameter_1519"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
      <Reaction key="Reaction_20" name="FBPase" reversible="false">
        <ListOfSubstrates>
          <Substrate metabolite="Metabolite_5" stoichiometry="1"/>
        </ListOfSubstrates>
        <ListOfProducts>
          <Product metabolite="Metabolite_4" stoichiometry="1"/>
          <Product metabolite="Metabolite_3" stoichiometry="1"/>
        </ListOfProducts>
        <ListOfConstants>
          <Constant key="Parameter_1518" name="Vmax_FBPase" value="0.0970486"/>
          <Constant key="Parameter_1517" name="kmF6P_FBPase" value="1.90796"/>
          <Constant key="Parameter_1516" name="kmFBP_FBPase" value="0.412307"/>
          <Constant key="Parameter_1515" name="kmPint_FBPase" value="0.0109675"/>
        </ListOfConstants>
        <KineticLaw function="Function_86">
          <ListOfCallParameters>
            <CallParameter functionParameter="FunctionParameter_826">
              <SourceParameter reference="Metabolite_4"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_827">
              <SourceParameter reference="Metabolite_5"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_828">
              <SourceParameter reference="Metabolite_3"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_829">
              <SourceParameter reference="Parameter_1518"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_830">
              <SourceParameter reference="Parameter_1517"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_831">
              <SourceParameter reference="Parameter_1516"/>
            </CallParameter>
            <CallParameter functionParameter="FunctionParameter_832">
              <SourceParameter reference="Parameter_1515"/>
            </CallParameter>
          </ListOfCallParameters>
        </KineticLaw>
      </Reaction>
    </ListOfReactions>
    <StateTemplate>
      <StateTemplateVariable objectReference="Model_0"/>
      <StateTemplateVariable objectReference="Metabolite_11"/>
      <StateTemplateVariable objectReference="Metabolite_9"/>
      <StateTemplateVariable objectReference="Metabolite_3"/>
      <StateTemplateVariable objectReference="Metabolite_6"/>
      <StateTemplateVariable objectReference="Metabolite_2"/>
      <StateTemplateVariable objectReference="Metabolite_4"/>
      <StateTemplateVariable objectReference="Metabolite_8"/>
      <StateTemplateVariable objectReference="Metabolite_15"/>
      <StateTemplateVariable objectReference="Metabolite_13"/>
      <StateTemplateVariable objectReference="Metabolite_12"/>
      <StateTemplateVariable objectReference="Metabolite_14"/>
      <StateTemplateVariable objectReference="Metabolite_0"/>
      <StateTemplateVariable objectReference="Metabolite_5"/>
      <StateTemplateVariable objectReference="Metabolite_18"/>
      <StateTemplateVariable objectReference="Metabolite_21"/>
      <StateTemplateVariable objectReference="Metabolite_25"/>
      <StateTemplateVariable objectReference="Metabolite_17"/>
      <StateTemplateVariable objectReference="Metabolite_22"/>
      <StateTemplateVariable objectReference="Metabolite_20"/>
      <StateTemplateVariable objectReference="Metabolite_7"/>
      <StateTemplateVariable objectReference="Metabolite_24"/>
      <StateTemplateVariable objectReference="Metabolite_10"/>
      <StateTemplateVariable objectReference="Metabolite_16"/>
      <StateTemplateVariable objectReference="Metabolite_23"/>
      <StateTemplateVariable objectReference="Metabolite_1"/>
      <StateTemplateVariable objectReference="Metabolite_19"/>
      <StateTemplateVariable objectReference="Compartment_0"/>
      <StateTemplateVariable objectReference="Compartment_1"/>
      <StateTemplateVariable objectReference="Compartment_2"/>
    </StateTemplate>
    <InitialState type="initialState">
      0 0 1.3217999014871e+020 1.08291358096138e+021 0 5.769979386595314e+020 0 7.016628328690636e+019 0 0 0 0 0 4.330522161189001e+020 0 0 0 3.011070895000001e+022 2.408856716e+022 0 3.576177219534769e+019 0 57552905377637.09 2.8304066413e+019 0 1.383028698287318e+020 0 1 0.047 1 
    </InitialState>
  </Model>
  <ListOfTasks>
    <Task key="Task_10" name="Steady-State" type="steadyState" scheduled="false" updateModel="false">
      <Report reference="Report_7" target="" append="1"/>
      <Problem>
        <Parameter name="JacobianRequested" type="bool" value="1"/>
        <Parameter name="StabilityAnalysisRequested" type="bool" value="1"/>
      </Problem>
      <Method name="Enhanced Newton" type="EnhancedNewton">
        <Parameter name="Resolution" type="unsignedFloat" value="1e-009"/>
        <Parameter name="Derivation Factor" type="unsignedFloat" value="0.001"/>
        <Parameter name="Use Newton" type="bool" value="1"/>
        <Parameter name="Use Integration" type="bool" value="1"/>
        <Parameter name="Use Back Integration" type="bool" value="1"/>
        <Parameter name="Accept Negative Concentrations" type="bool" value="0"/>
        <Parameter name="Iteration Limit" type="unsignedInteger" value="50"/>
        <Parameter name="Maximum duration for forward integration" type="unsignedFloat" value="1000000000"/>
        <Parameter name="Maximum duration for backward integration" type="unsignedFloat" value="1000000"/>
      </Method>
    </Task>
    <Task key="Task_9" name="Time-Course" type="timeCourse" scheduled="false" updateModel="false">
      <Problem>
        <Parameter name="StepNumber" type="unsignedInteger" value="100"/>
        <Parameter name="StepSize" type="float" value="0.01"/>
        <Parameter name="Duration" type="float" value="1"/>
        <Parameter name="TimeSeriesRequested" type="bool" value="1"/>
        <Parameter name="OutputStartTime" type="float" value="0"/>
        <Parameter name="Output Event" type="bool" value="0"/>
      </Problem>
      <Method name="Deterministic (LSODA)" type="Deterministic(LSODA)">
        <Parameter name="Integrate Reduced Model" type="bool" value="0"/>
        <Parameter name="Relative Tolerance" type="unsignedFloat" value="1e-006"/>
        <Parameter name="Absolute Tolerance" type="unsignedFloat" value="1e-012"/>
        <Parameter name="Max Internal Steps" type="unsignedInteger" value="10000"/>
      </Method>
    </Task>
    <Task key="Task_8" name="Scan" type="scan" scheduled="false" updateModel="false">
      <Problem>
        <Parameter name="Subtask" type="unsignedInteger" value="1"/>
        <ParameterGroup name="ScanItems">
        </ParameterGroup>
        <Parameter name="Output in subtask" type="bool" value="1"/>
        <Parameter name="Adjust initial conditions" type="bool" value="0"/>
      </Problem>
      <Method name="Scan Framework" type="ScanFramework">
      </Method>
    </Task>
    <Task key="Task_7" name="Elementary Flux Modes" type="fluxMode" scheduled="false" updateModel="false">
      <Report reference="Report_6" target="" append="1"/>
      <Problem>
      </Problem>
      <Method name="EFM Algorithm" type="EFMAlgorithm">
      </Method>
    </Task>
    <Task key="Task_6" name="Optimization" type="optimization" scheduled="false" updateModel="false">
      <Report reference="Report_5" target="" append="1"/>
      <Problem>
        <Parameter name="Subtask" type="cn" value="CN=Root,Vector=TaskList[Steady-State]"/>
        <ParameterText name="ObjectiveExpression" type="expression">
          
        </ParameterText>
        <Parameter name="Maximize" type="bool" value="0"/>
        <Parameter name="Randomize Start Values" type="bool" value="0"/>
        <Parameter name="Calculate Statistics" type="bool" value="1"/>
        <ParameterGroup name="OptimizationItemList">
        </ParameterGroup>
        <ParameterGroup name="OptimizationConstraintList">
        </ParameterGroup>
      </Problem>
      <Method name="Random Search" type="RandomSearch">
        <Parameter name="Number of Iterations" type="unsignedInteger" value="100000"/>
        <Parameter name="Random Number Generator" type="unsignedInteger" value="1"/>
        <Parameter name="Seed" type="unsignedInteger" value="0"/>
      </Method>
    </Task>
    <Task key="Task_5" name="Parameter Estimation" type="parameterFitting" scheduled="false" updateModel="false">
      <Report reference="Report_4" target="" append="1"/>
      <Problem>
        <Parameter name="Maximize" type="bool" value="0"/>
        <Parameter name="Randomize Start Values" type="bool" value="0"/>
        <Parameter name="Calculate Statistics" type="bool" value="1"/>
        <ParameterGroup name="OptimizationItemList">
        </ParameterGroup>
        <ParameterGroup name="OptimizationConstraintList">
        </ParameterGroup>
        <Parameter name="Steady-State" type="cn" value="CN=Root,Vector=TaskList[Steady-State]"/>
        <Parameter name="Time-Course" type="cn" value="CN=Root,Vector=TaskList[Time-Course]"/>
        <ParameterGroup name="Experiment Set">
        </ParameterGroup>
      </Problem>
      <Method name="Evolutionary Programming" type="EvolutionaryProgram">
        <Parameter name="Number of Generations" type="unsignedInteger" value="200"/>
        <Parameter name="Population Size" type="unsignedInteger" value="20"/>
        <Parameter name="Random Number Generator" type="unsignedInteger" value="1"/>
        <Parameter name="Seed" type="unsignedInteger" value="0"/>
      </Method>
    </Task>
    <Task key="Task_4" name="Metabolic Control Analysis" type="metabolicControlAnalysis" scheduled="false" updateModel="false">
      <Report reference="Report_3" target="" append="1"/>
      <Problem>
        <Parameter name="Steady-State" type="key" value="Task_10"/>
      </Problem>
      <Method name="MCA Method (Reder)" type="MCAMethod(Reder)">
        <Parameter name="Modulation Factor" type="unsignedFloat" value="1e-009"/>
      </Method>
    </Task>
    <Task key="Task_3" name="Lyapunov Exponents" type="lyapunovExponents" scheduled="false" updateModel="false">
      <Report reference="Report_2" target="" append="1"/>
      <Problem>
        <Parameter name="ExponentNumber" type="unsignedInteger" value="3"/>
        <Parameter name="DivergenceRequested" type="bool" value="1"/>
        <Parameter name="TransientTime" type="float" value="0"/>
      </Problem>
      <Method name="Wolf Method" type="WolfMethod">
        <Parameter name="Orthonormalization Interval" type="unsignedFloat" value="1"/>
        <Parameter name="Overall time" type="unsignedFloat" value="1000"/>
        <Parameter name="Relative Tolerance" type="unsignedFloat" value="1e-006"/>
        <Parameter name="Absolute Tolerance" type="unsignedFloat" value="1e-012"/>
        <Parameter name="Max Internal Steps" type="unsignedInteger" value="10000"/>
      </Method>
    </Task>
    <Task key="Task_2" name="Time Scale Separation Analysis" type="timeScaleSeparationAnalysis" scheduled="false" updateModel="false">
      <Report reference="Report_1" target="" append="1"/>
      <Problem>
        <Parameter name="StepNumber" type="unsignedInteger" value="100"/>
        <Parameter name="StepSize" type="float" value="0.01"/>
        <Parameter name="Duration" type="float" value="1"/>
        <Parameter name="TimeSeriesRequested" type="bool" value="1"/>
        <Parameter name="OutputStartTime" type="float" value="0"/>
      </Problem>
      <Method name="ILDM (LSODA,Deuflhard)" type="TimeScaleSeparation(ILDM,Deuflhard)">
        <Parameter name="Deuflhard Tolerance" type="unsignedFloat" value="1e-006"/>
      </Method>
    </Task>
    <Task key="Task_1" name="Sensitivities" type="sensitivities" scheduled="false" updateModel="false">
      <Report reference="Report_0" target="" append="1"/>
      <Problem>
        <Parameter name="SubtaskType" type="unsignedInteger" value="1"/>
        <ParameterGroup name="TargetFunctions">
          <Parameter name="SingleObject" type="cn" value=""/>
          <Parameter name="ObjectListType" type="unsignedInteger" value="7"/>
        </ParameterGroup>
        <ParameterGroup name="ListOfVariables">
          <ParameterGroup name="Variables">
            <Parameter name="SingleObject" type="cn" value=""/>
            <Parameter name="ObjectListType" type="unsignedInteger" value="41"/>
          </ParameterGroup>
        </ParameterGroup>
      </Problem>
      <Method name="Sensitivities Method" type="SensitivitiesMethod">
        <Parameter name="Delta factor" type="unsignedFloat" value="0.001"/>
        <Parameter name="Delta minimum" type="unsignedFloat" value="1e-012"/>
      </Method>
    </Task>
    <Task key="Task_11" name="Moieties" type="moieties" scheduled="false" updateModel="false">
      <Problem>
      </Problem>
      <Method name="Householder Reduction" type="Householder">
      </Method>
    </Task>
  </ListOfTasks>
  <ListOfReports>
    <Report key="Report_7" name="Steady-State" taskType="steadyState" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Footer>
        <Object cn="CN=Root,Vector=TaskList[Steady-State]"/>
      </Footer>
    </Report>
    <Report key="Report_6" name="Elementary Flux Modes" taskType="fluxMode" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Footer>
        <Object cn="CN=Root,Vector=TaskList[Elementary Flux Modes],Object=Result"/>
      </Footer>
    </Report>
    <Report key="Report_5" name="Optimization" taskType="optimization" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Header>
        <Object cn="CN=Root,Vector=TaskList[Optimization],Object=Description"/>
        <Object cn="String=\[Function Evaluations\]"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="String=\[Best Value\]"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="String=\[Best Parameters\]"/>
      </Header>
      <Body>
        <Object cn="CN=Root,Vector=TaskList[Optimization],Problem=Optimization,Reference=Function Evaluations"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="CN=Root,Vector=TaskList[Optimization],Problem=Optimization,Reference=Best Value"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="CN=Root,Vector=TaskList[Optimization],Problem=Optimization,Reference=Best Parameters"/>
      </Body>
      <Footer>
        <Object cn="String=&#x0a;"/>
        <Object cn="CN=Root,Vector=TaskList[Optimization],Object=Result"/>
      </Footer>
    </Report>
    <Report key="Report_4" name="Parameter Estimation" taskType="parameterFitting" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Header>
        <Object cn="CN=Root,Vector=TaskList[Parameter Estimation],Object=Description"/>
        <Object cn="String=\[Function Evaluations\]"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="String=\[Best Value\]"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="String=\[Best Parameters\]"/>
      </Header>
      <Body>
        <Object cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,Reference=Function Evaluations"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,Reference=Best Value"/>
        <Object cn="Separator=&#x09;"/>
        <Object cn="CN=Root,Vector=TaskList[Parameter Estimation],Problem=Parameter Estimation,Reference=Best Parameters"/>
      </Body>
      <Footer>
        <Object cn="String=&#x0a;"/>
        <Object cn="CN=Root,Vector=TaskList[Parameter Estimation],Object=Result"/>
      </Footer>
    </Report>
    <Report key="Report_3" name="Metabolic Control Analysis" taskType="metabolicControlAnalysis" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Header>
        <Object cn="CN=Root,Vector=TaskList[Metabolic Control Analysis],Object=Description"/>
      </Header>
      <Footer>
        <Object cn="String=&#x0a;"/>
        <Object cn="CN=Root,Vector=TaskList[Metabolic Control Analysis],Object=Result"/>
      </Footer>
    </Report>
    <Report key="Report_2" name="Lyapunov Exponents" taskType="lyapunovExponents" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Header>
        <Object cn="CN=Root,Vector=TaskList[Lyapunov Exponents],Object=Description"/>
      </Header>
      <Footer>
        <Object cn="String=&#x0a;"/>
        <Object cn="CN=Root,Vector=TaskList[Lyapunov Exponents],Object=Result"/>
      </Footer>
    </Report>
    <Report key="Report_1" name="Time Scale Separation Analysis" taskType="timeScaleSeparationAnalysis" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Header>
        <Object cn="CN=Root,Vector=TaskList[Time Scale Separation Analysis],Object=Description"/>
      </Header>
      <Footer>
        <Object cn="String=&#x0a;"/>
        <Object cn="CN=Root,Vector=TaskList[Time Scale Separation Analysis],Object=Result"/>
      </Footer>
    </Report>
    <Report key="Report_0" name="Sensitivities" taskType="sensitivities" separator="&#x09;" precision="6">
      <Comment>
        Automatically generated report.
      </Comment>
      <Header>
        <Object cn="CN=Root,Vector=TaskList[Sensitivities],Object=Description"/>
      </Header>
      <Footer>
        <Object cn="String=&#x0a;"/>
        <Object cn="CN=Root,Vector=TaskList[Sensitivities],Object=Result"/>
      </Footer>
    </Report>
  </ListOfReports>
  <GUI>
  </GUI>
  <SBMLReference file="Extended_LlactisKinetic_Model.xml">
    <SBMLMap SBMLid="ADP" COPASIkey="Metabolite_2"/>
    <SBMLMap SBMLid="ATP" COPASIkey="Metabolite_1"/>
    <SBMLMap SBMLid="AcetCoA" COPASIkey="Metabolite_12"/>
    <SBMLMap SBMLid="Acetate" COPASIkey="Metabolite_20"/>
    <SBMLMap SBMLid="Acetoin" COPASIkey="Metabolite_13"/>
    <SBMLMap SBMLid="Acetoin_Ext" COPASIkey="Metabolite_23"/>
    <SBMLMap SBMLid="BPG" COPASIkey="Metabolite_7"/>
    <SBMLMap SBMLid="Butanediol" COPASIkey="Metabolite_21"/>
    <SBMLMap SBMLid="CoA" COPASIkey="Metabolite_16"/>
    <SBMLMap SBMLid="Ethanol" COPASIkey="Metabolite_19"/>
    <SBMLMap SBMLid="F6P" COPASIkey="Metabolite_4"/>
    <SBMLMap SBMLid="FBP" COPASIkey="Metabolite_5"/>
    <SBMLMap SBMLid="Formate" COPASIkey="Metabolite_25"/>
    <SBMLMap SBMLid="G3P" COPASIkey="Metabolite_6"/>
    <SBMLMap SBMLid="G6P" COPASIkey="Metabolite_0"/>
    <SBMLMap SBMLid="Glucose" COPASIkey="Metabolite_22"/>
    <SBMLMap SBMLid="Lactate" COPASIkey="Metabolite_18"/>
    <SBMLMap SBMLid="Mannitol" COPASIkey="Metabolite_14"/>
    <SBMLMap SBMLid="Mannitol1Phosphate" COPASIkey="Metabolite_15"/>
    <SBMLMap SBMLid="Mannitol_Ext" COPASIkey="Metabolite_24"/>
    <SBMLMap SBMLid="NAD" COPASIkey="Metabolite_9"/>
    <SBMLMap SBMLid="NADH" COPASIkey="Metabolite_10"/>
    <SBMLMap SBMLid="PEP" COPASIkey="Metabolite_8"/>
    <SBMLMap SBMLid="PYR" COPASIkey="Metabolite_11"/>
    <SBMLMap SBMLid="Pext" COPASIkey="Metabolite_17"/>
    <SBMLMap SBMLid="Pint" COPASIkey="Metabolite_3"/>
    <SBMLMap SBMLid="compartment_1" COPASIkey="Compartment_1"/>
    <SBMLMap SBMLid="compartment_2" COPASIkey="Compartment_2"/>
    <SBMLMap SBMLid="default" COPASIkey="Compartment_0"/>
    <SBMLMap SBMLid="re12" COPASIkey="Reaction_0"/>
    <SBMLMap SBMLid="re13" COPASIkey="Reaction_1"/>
    <SBMLMap SBMLid="re14" COPASIkey="Reaction_2"/>
    <SBMLMap SBMLid="re15" COPASIkey="Reaction_3"/>
    <SBMLMap SBMLid="re16" COPASIkey="Reaction_4"/>
    <SBMLMap SBMLid="re17" COPASIkey="Reaction_5"/>
    <SBMLMap SBMLid="re18" COPASIkey="Reaction_6"/>
    <SBMLMap SBMLid="re20" COPASIkey="Reaction_7"/>
    <SBMLMap SBMLid="re21" COPASIkey="Reaction_8"/>
    <SBMLMap SBMLid="re22" COPASIkey="Reaction_9"/>
    <SBMLMap SBMLid="re23" COPASIkey="Reaction_10"/>
    <SBMLMap SBMLid="re24" COPASIkey="Reaction_11"/>
    <SBMLMap SBMLid="re25" COPASIkey="Reaction_12"/>
    <SBMLMap SBMLid="re26" COPASIkey="Reaction_13"/>
    <SBMLMap SBMLid="re27" COPASIkey="Reaction_14"/>
    <SBMLMap SBMLid="re28" COPASIkey="Reaction_15"/>
    <SBMLMap SBMLid="re29" COPASIkey="Reaction_16"/>
    <SBMLMap SBMLid="re30" COPASIkey="Reaction_17"/>
    <SBMLMap SBMLid="re31" COPASIkey="Reaction_18"/>
    <SBMLMap SBMLid="re32" COPASIkey="Reaction_19"/>
    <SBMLMap SBMLid="re33" COPASIkey="Reaction_20"/>
  </SBMLReference>
</COPASI>
