%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Glycolysis6
 
    % Glycolytic pathway and metabolism downstream of pyruvate in L.Lactis
    % Adapts : (Uses original function from Voit IEE Syst Biol 2006)
    % 
    % Anaerobic case - glucose pulse 40mM
 
    global ATPSpline PiSpline NADSpline
    
    % Read Data from Mat file
    load Lactococcus_Data_ANA
        
    % Time points
    tStart = 1;
    %just to maintain coherence...
    tEnd = 63;
    tData = Data(tStart:tEnd,1);
    
    %-----Concentration Values
    GlucoseData=Data(tStart:tEnd,2);
    LactateData=Data(tStart:tEnd,3);
    AcetateData=Data(tStart:tEnd,4);
    
    PEPData=Data(tStart:tEnd,7);
    P3GAData=Data(tStart:tEnd,8);
    
    FBPData=Data(tStart:tEnd,9);
    
    %modeled variables only glu,fbp,3pga,pep,lac
    yData = horzcat(GlucoseData, FBPData, P3GAData, PEPData, LactateData);
       
    %****add new********
    PGAPEPData = P3GAData + PEPData;
    %K45=2.04035;  %****from measurments - Karl's estimation
    K45=1.54695;  %****from measurments - Karl's estimation
    P3GAData = K45/(1+K45) * PGAPEPData;
    PEPData = 1/(1+K45) * PGAPEPData;
     
    %------Offline Concentration Values
    NADData=Data(tStart:tEnd,5);
    %new
    NADHData=Data(tStart:tEnd,6);
    
    tData2=Data2(:,1); %different times for NTP and Pi measurments!
    ATPData=Data2(:,2);
    PiData=Data2(:,3);
    
    %-------splines/smoothing
    %NADSpline = spline(tData, NADData);
    
    k=1;
    NADSpline = spline(tData(2:end), k*[0 NADData(2:end)' 0]); %exclude first point and impose zero derivates in min and max (y)
    NADSpline = fnxtr(NADSpline,1);
    
    %ATPSpline = spline(tData, ATPData);
    k=1;
    ATPSpline = spline(tData2(1:7), k*[0 0.01 ATPData(2:6)' 0.01 0]); %ATP(t0)=ATP(tf)=0.01 and impose 0 derivatives at extreme
    ATPSpline = fnxtr(ATPSpline,1);  %extrapolate values outside interval tData2(1:7) as one-order
    
    %test other approximations
%     coeff=polyfit(tData2(1:7)',[0.01 ATPData(2:6)' 0.01],3);
%     ATPSpline=mkpp([0 15.1250 80], [coeff;0 0 0 0.01]);
    
    %PiSpline = spline(tData, PiData);
    %PiSpline = spline(tData2([1 3:27]), [0 36.94 PiData(3:27)' 0]); %exclude missing value at tData(2) and Pi(2), same zero derivative
    
    k=1;
    PiSpline = spline(tData2([1 2:27]), k*[0 38.16 PiData(2:27)' 0]); %impose initial value - tune this, same zero derivative
    PiSpline = fnxtr(PiSpline,1);    %extrapolate maintaining derivative
    
    save splines_ANA NADSpline ATPSpline PiSpline 
 
    %------Initial Concentration Values
    X0old = yData(1,:);    %now is just 5 rows
    
    %Karl's initial conditions
    X0 = [40,  0.1,  0.72,   0.94*40,    0.1,      0.01 ];
%         Glu  G6P   FBP   PGAPEP   Pyruvate, Lactacte   

   %X0 = [40, 0.1, 0.72, 2.45*(5.6900+10.0700), 0.1, 0.01];
          
    load paramsANA
    %load paramsANA2
   %[0.124738000000000,0.134194000000000,2.66740000000000,5.86735000000000,1.25193000000000,-1.06961000000000,0.288687000000000,0.379794000000000,2.83465000000000,0.262030000000000,0.181082000000000,1.02783000000000,-0.137778000000000,0.174484000000000,0.000447956000000000,0.103001000000000,0.683548000000000,0.854603000000000,0.0921911000000000,-0.279396000000000,0.0306174000000000,0.844840000000000,0.958361000000000,0.388040000000000,1.91581200000000,1.08493000000000,1.54695000000000;]
    %[tROS, XROS] = ode15s(@returnVelocity, tData, X0, [], params);
    %increase resolution for better plotting
    
    %options=odeset('AbsTol',eps,'RelTol',eps)
    %options=odeset('AbsTol',1e-10,'RelTol',1e-10)
    %[tROS, XROS] = ode15s(@returnVelocity, linspace(tData(1),tData(end),500), X0, options,params);
    %[tROS, XROS] = ode15s(@returnVelocity, linspace(tData(1),tData(end)), X0, options,params);
    
      [tROS, XROS] = ode15s(@returnVelocity, linspace(tData(1),tData(end)), X0, [],params);

    % Save Results
    save Glycolysis_estimation_and_simulation_results_vC_ANA params tData yData tROS XROS
    
    %Plot_Species
    
    %real...
    plot(tData,yData,'.', 'LineWidth',2);   %original data - plot modeled variabels glu,fbp,3pga,pep,lac
    hold on;
    
    %and simulated...
    SIM = [XROS(:,[1 3]) K45/(1+K45)*XROS(:,4) 1/(1+K45)*XROS(:,4) XROS(:,[6])];
    plot(tROS,SIM,'LineWidth', 2);
%     plot(tROS, XROS(:,[1 3 6]), 'LineWidth', 2);   %simulations of Glu  G6P   FBP   PGAPEP   Pyruvate Lactacte
%     %plot(tData,P3GAData,'gx','linewidth',2);
%     plot(tROS,K45/(1+K45)*XROS(:,4),'g-','LineWidth',2);
%     %plot(tData,PEPData,'cx','linewidth',2);
%     plot(tROS,1/(1+K45)*XROS(:,4),'c-','LineWidth',2);
%     %lactacte at the end
%     %plot(tROS, XROS(:,[6]), 'LineWidth', 2);   %simulations of Glu  G6P   FBP   PGAPEP   Pyruvate Lactacte
%     %legend({'Glu', 'FBP', '3PGA' 'PEP' 'Lac', 'Gluf' , 'G6Pf', 'FBPf', 'PGAPEPf', 'Pyrf', 'Lacf','3PGA','PGAf', 'PEP', 'PEPf'});
    legend({'Glu', 'FBP', '3PGA' ,'PEP', 'Lac', 'Gluf' , 'FBPf', 'PGAf', 'PEPf', 'Lacf'});
    xlabel('Time [min]');
    ylabel('concentration [mM]');
    title('Glucose pulse 40mM - Anaerobic conditions');

%     %plot(tData,GlucoseData,'.-');
%     plot(tData,P3GAData,'.');
%     plot(tData,PEPData,'.');
    
    nRows = 2;
    nCols = 3;
    
    figure;
    
    subplot(nRows,nCols,1)
    plot(tData, GlucoseData, 'b.', 'linewidth', 2);
    hold on;
    plot(tROS, XROS(:,1), 'b', 'linewidth', 2);
    legend('glu');
    hold off;
 
    subplot(nRows,nCols,2)
    plot(tData, FBPData, 'g.', 'linewidth', 2);
    hold on;
    plot(tROS, XROS(:,3), 'g', 'linewidth', 2);
    legend('FBP');
    hold off;
 
    subplot(nRows,nCols,3)
    plot(tData, P3GAData, 'r.', 'linewidth', 2);
    hold on;
    plot(tROS, SIM(:,3), 'r', 'linewidth', 2);
    legend('3PGA');
    hold off;
 
    subplot(nRows,nCols,4)
    plot(tData, PEPData, 'k.', 'linewidth', 2);
    hold on;
    plot(tROS, SIM(:,4), 'k', 'linewidth', 2);
    legend('PEP');
    hold off;
    
    subplot(nRows,nCols,5)
    plot(tData, LactateData, 'r.', 'linewidth', 2);
    hold on;
    plot(tROS, XROS(:,6), 'r', 'linewidth', 2);
    legend('Lactate');
    hold off;
    
    subplot(nRows,nCols,6)
    plot(tROS, XROS(:,[2,5]), 'linewidth', 2);
    hold on
    plot(tData(2:end), NADData(2:end),'.',tData2(1:7),[0.01 ATPData(2:6)' 0.01],'.',tData2([1 3:27]), [36.94 PiData(3:27)'],'.');
    legend({'G6P' 'Pyr' 'NAD+' 'ATP' 'Pi'});
    hold off;
    
    figure;
    plot(tROS, XROS(:,[2,5]), 'linewidth', 2);
    hold on
    plot(tData(2:end), NADData(2:end),'*',tData2(1:7),[0.01 ATPData(2:6)' 0.01],'*',tData2([1 3:27]), [36.94 PiData(3:27)'],'*');
    legend({'G6P' 'Pyr' 'NAD+' 'ATP' 'Pi'},0);
    xlabel('Time [min]');
    ylabel('concentration [mM]');
    title('Glucose pulse 40mM - Anaerobic conditions');
   
 
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function dX = returnVelocity(t, X, param)
    
    global NADSpline ATPSpline PiSpline
    
    sfg=1e-5;

    %input signals
    NAD = ppval(NADSpline, t); %u0   
    ATP = ppval(ATPSpline, t);  %u1
    Pi  = ppval(PiSpline, t);    %u2
 
%  %Karl's initial conditions
%     X0 = [40,  0.1,  0.72,   40,    0.1,      0.01 ];
% %         Glu  G6P   FBP   PGAPEP   Pyruvate, Lactacte   
             
    Glu = X(1);
    G6P = X(2);
    FBP = X(3);
    PGAPEP = X(4);
    
    K45 = 2.0403500; %now it's global- doesn't work
    PEP = 1/(1+K45) * PGAPEP;
    
    Pyruvate = X(5);
    Lactacte = X(6); 
   % Acetate = X(5); %needed? NO
   
    %fluxes
    vGlu        = - param(1) * (1 + param(2)*(t+sfg)^param(3)) * Glu;
    
    vG6P        = param(4)*((Glu+sfg)^param(5))*((G6P+sfg)^param(6))*((PEP+sfg)^param(7))  - param(8)*((G6P+sfg)^param(9))*(ATP^param(10));
    
    vFBP        = param(8)*((G6P+sfg)^param(9))*(ATP^param(10))                - param(11)*((FBP+sfg)^param(12))*(Pi^param(13))*(NAD^param(14));
    
    %merge signals 3PGA+PEP------------

    vPGAPEP = 2*param(11)*((FBP+sfg)^param(12))*(Pi^param(13))*(NAD^param(14)) - param(4)*((Glu+sfg)^param(5))*((G6P+sfg)^param(6))*((PEP+sfg)^param(7)) ...            
                                                                         - param(15)*((PEP+sfg)^param(16)) ...
                                                                         - param(17)*((FBP+sfg)^param(18))*((PEP+sfg)^param(19))*(Pi^param(20));                                                             
    %----------------------------------   
    
    vPyruvate   = param(4)*((Glu+sfg)^param(5))*((G6P+sfg)^param(6))*((PEP+sfg)^param(7)) ...
                  + param(17)*((FBP+sfg)^param(18))*((PEP+sfg)^param(19))*(Pi^param(20))    - param(21)*((Pyruvate+sfg)^param(22))*((FBP+sfg)^param(23))*(NAD^param(24)) ...
                                                                                - param(25)*((Pyruvate+sfg)^param(26));
 
    vLactate    = param(21)*((Pyruvate+sfg)^param(22))*((FBP+sfg)^param(23))*(NAD^param(24));

    dX = [vGlu; vG6P; vFBP; vPGAPEP; vPyruvate; vLactate];
         % Glu  G6P   FBP   PGAPEP   Pyruvate, Lactacte   
    
    dX = real(dX);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
