% Finding alternative steady states:

function Results = FindingAltSteadyStates(NumOfSearches)

if isempty(NumOfSearches)
    NumOfSearches = 1000;
end

IC = InitConds;
plot([0; 2],[IC';IC'],':k','LineWidth',3)

w = waitbar(0,'Please wait...');
Results.Sim = [];
Results.SS = [];
count = 0;
for i = 1:NumOfSearches
    AIC = IC.*rand(31,1)*3; % Adjustment to initial conditions
    AIC(1) = IC(1);
    AIC(2) = IC(2);
    AIC(27) = IC(27);
    
    [t2,x2] = ode15s(@EColi_ContCult_NoGlcOrXDyn, [0 2], AIC);
    
    if max(real(x2(end,:))) < 20
        PercConcDiff = 100 * (IC' - x2(end,:))./IC';
        PercConcDiff(4) = []; % Let's ignore the change in G1P
        % Only interested in solutions where any concentration is changed
        % by >10%.
        if max(abs(PercConcDiff)) > 1
            count = count + 1;
            Results.Sim{count} = [t2 x2];
            
            Jacobian2 = SystemJacobian(@EColi_ContCult_NoGlcOrXDyn, x2(end,:));
            EV2 = eig(Jacobian2); % All Eigenvalues of system are >= 0, implying stable steady state.
            if max(real(EV2)) <= 0
                Results.SS{count} = 1;
            else
                Results.SS{count} = 0;
            end
            
            hold on
            plot(t2,x2)
            hold off
            axis([0 2 0 2])
        end
    end
    
    waitbar(i/NumOfSearches)
end
close(w)
