%function Run_KurataModel_Continuous()
clear all;
close all;
tic;

global strain_no continuous_flg ;

options = odeset('RelTol',1e-10,'AbsTol',1e-10); %
n_FLUX = 155;
ode_file = @KurataModel_ODE;
flux_file = @KurataModel_Flux;

for i= 1:1:25
switch i
    case 1
    % RF06, WT(Oct),WT, 0.2h-1
    SampleID = 'RF06';
    strain_no = 1;
    continuous_flg = 1;
    case 2
    % GR02 WT, 0.4h-1
    SampleID = 'GR02';
    strain_no = 1;
    continuous_flg = 3;        
    case 3
    % GR03 WT, 0.5h-1
    SampleID = 'GR03';
    strain_no = 1;
    continuous_flg = 4;       
    case 4
    % GR04 WT, 0.7h-1
    SampleID = 'GR04';
    strain_no = 1;
    continuous_flg = 5;
    
    case 5
    SampleID = 'KO02'; %Delta glk
    strain_no = 2;
    continuous_flg = 1;

    case 6
    SampleID = 'KO04'; %Delta pgi
    strain_no = 4;
    continuous_flg = 1;

    case 7
    SampleID = 'KO05'; %Delta pfkA
    strain_no = 5;
    continuous_flg = 1;
    
    case 8
    SampleID = 'KO06'; %Delta pfkB
    strain_no = 6;
    continuous_flg = 1;

    case 9
    SampleID = 'KO07'; %Delta fbp
    strain_no = 7;
    continuous_flg = 1;

    case 10
    SampleID = 'KO08'; %Delta fbaB
    strain_no = 8;
    continuous_flg = 1;

    case 11
    SampleID = 'KO10'; % Delta gpmA
    strain_no = 10;
    continuous_flg = 1;
    
    case 12
    SampleID = 'KO12'; % Delta pykA
    strain_no = 12;
    continuous_flg = 1;
    
    case 13
    SampleID = 'KO13'; % Delta pykF
    strain_no = 13;
    continuous_flg = 1;
    
    case 14
    SampleID = 'KO14'; %Delta ppsA
    strain_no = 14;
    continuous_flg = 1;

    case 15
    SampleID = 'KO15'; %Delta zwf (G6pdh)
    strain_no = 15;
    continuous_flg = 1;

    case 16
    SampleID =  'KO16'; %Delta pgl
    strain_no = 16;
    continuous_flg = 1;

    case 17
    SampleID = 'KO17'; % Delta gnd (6Pgdh)
    strain_no = 17;
    continuous_flg = 1;

    case 18
    SampleID = 'KO18'; %Delta rpe 
    strain_no = 18;
    continuous_flg = 1;

    case 19
    SampleID = 'KO19'; % Delta rpiA (R5pi)
    strain_no = 19;
    continuous_flg = 1;

    case 20
    SampleID = 'KO20'; % Delta rpiB (R5pi)
    strain_no = 20;
    continuous_flg = 1;
    
    case 21
    SampleID = 'KO21'; % Delta tktA
    strain_no = 21;
    continuous_flg = 1;

    case 22
    SampleID = 'KO22'; %Delta tktB
    strain_no = 22;
    continuous_flg = 1;

    case 23
    SampleID = 'KO23'; %Delta talA 
    strain_no = 23;
    continuous_flg = 1;
    
    case 24
    SampleID = 'KO24'; %Delta talB 
    strain_no = 24;
    continuous_flg = 1;
    
    case 25
    % Delta ppc, D=0.2h-1
    SampleID = 'DeltaPpc'; %Delta ppc
    strain_no = 25;
    continuous_flg = 1;
end

%% Simulation
span = -10:0.1:200;
y0 = getInitialCondition();
y0( 1) = 1; % X
y0( 2) = 1; % GLCex
y0(12) = 1; % ACEex
[ T, Y, FLUX ] = runSimulation(ode_file,flux_file,span,y0,options);
Y = real(Y); FLUX = real(FLUX);
plotContinuousFlux(FLUX(end,:), SampleID);
save(sprintf('result_cont_%s.mat',SampleID),'T','Y','FLUX');
toc;

end

return

