function Flux = ExpDataForContinuousCulture(SampleID)
% For details see supporting xls file of the following paper.
% Ishii N, Nakahigashi K, Baba T, Robert M, Soga T, Kanai A, Hirasawa T,
% Naba M, Hirai K, Hoque A et al: Multiple high-throughput analyses monitor
% the response of E-coli to perturbations. Science 2007, 316(5824):593-597.
%
% Elements of Flux
%  1: Glucose + PEP -> G6P + PYR
%  2: G6P <-> F6P
%  3: F6P -> F1,6P
%  4: F1,6P -> DHAP + G3P
%  5: DHAP -> G3P
%  6: G3P -> 3PG  (Pgk)
%  7: 3PG <-> PEP (Eno)
%  8: PEP -> PYR
%  9: PYR -> AcCoA + CO2
% 10: G6P -> 6PG
% 11: 6PG -> RU5P + CO2
% 12: RU5P -> X5P
% 13: RU5P -> R5P
% 14: R5P + X5P <-> S7P + G3P
% 15: S7P + G3P <-> E4P + F6P
% 16: X5P + E4P <-> F6P + G3P
% 17: AcCoA + OAA -> CIT
% 18: CIT -> ICT
% 19: ICT -> aKG + CO2
% 20: aKG -> SUC + CO2
% 21: SUC -> FUM
% 22: FUM -> MAL
% 23: MAL <-> OAA
% 24: PEP + CO2 <-> OAA
% 25: MAL -> PYR + CO2
% 26: ICT -> GOX + SUC
% 27: GOX + AcCoA -> MAL
% 28: 6-PG -> G3P + PYR  (Edd, Eda)
% 29: AcCoA -> ACE
% 30: PYR -> Lactate
% 31: AcCoA -> Ethanol
% 32: G6P -> (Cell synthesis)
% 33: F6P -> (Cell synthesis)
% 34: R5P -> (Cell synthesis)
% 35: E4P -> (Cell synthesis)
% 36: G3P -> (Cell synthesis)
% 37: 3PG -> (Cell synthesis)
% 38: PEP -> (Cell synthesis)
% 39: PYR -> (Cell synthesis)
% 40: AcCoA -> (Cell synthesis)
% 41: OAA -> (Cell synthesis)
% 42: 2KG -> (Cell synthesis)
% 43: CO2 -> (Evolution)
% 44: Exch. (G6P <-> F6P)
% 45: Exch. (3PG <-> PEP)
% 46: Exch. (R5P + X5P <-> S7P + G3P)
% 47: Exch. (S7P + G3P <-> E4P + F6P)
% 48: Exch. (X5P + E4P <-> F6P + G3P)
% 49: Exch. (MAL <-> OAA)
% 50: Exch. (PEP + CO2 <-> OAA)


switch SampleID
    %
    case 'KO01' % KO01 galM
        Flux = [ 100, 64, 81, 81, 81, 168, 159, 55, 141, 35,...
            35, 18, 17, 10, 10, 7, 87, 87, 61, 53,...
            79, 79, 100, 0, 5, 26, 26, 0, 0, 0,...
            0, 1, 1, 7, 3, 1, 10, 4, 20, 27,...
            13, 8, 295, 0.91, 0.00, 0.00, 0.70, 0.01, 0.93, 0.30 ];
    case 'KO02' % KO02 glk
        Flux = [ 100, 87, 89, 89, 89, 177, 167, 51, 132, 12,...
            12, 3, 9, 3, 3, 0, 98, 98, 91, 83,...
            91, 91, 98, 13, 0, 7, 7, 0, 0, 0,...
            0, 1, 1, 6, 3, 1, 9, 3, 19, 26,...
            13, 8, 305, 0.95, 0.95, 0.00, 0.59, 0.00, 0.94, 0.31 ];
    case 'KO03' % KO03 pgm
        Flux = [ 100, 78, 86, 86, 86, 173, 164, 50, 130, 21,...
            21, 8, 12, 6, 6, 3, 93, 93, 82, 74,...
            85, 85, 96, 10, 0, 11, 11, 0, 0, 0,...
            0, 1, 1, 6, 3, 1, 10, 4, 20, 27,...
            13, 8, 296, 0.93, 0.95, 0.00, 0.68, 0.00, 0.95, 0.35 ];
    case 'KO04' % KO04 pgi
        Flux = [100, 0, 34, 34, 34, 120, 109, 5, 122, 98,...
            61, 35, 26, 19, 19, 16, 67, 67, 41, 33,...
            58, 58, 81, 0, 2, 25, 25, 37, 0, 0,...
            0, 2, 1, 7, 3, 1, 11, 4, 22, 30,...
            15, 9, 259, 0, 0.42, 0.95, 0.53, 0.12, 0.51, 0.08 ];
    case 'KO05' % KO05 pfkA_2
        Flux = [ 100, 84, 87, 87, 87, 173, 162, 43, 120, 14,...
            14, 3, 11, 3, 3, 0, 82, 82, 73, 64,...
            73, 73, 81, 15, 0, 8, 8, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 11, 4, 23, 30,...
            15, 9, 256, 0.94, 0.95, 0.00, 0.48, 0.00, 0.95, 0.45 ];
    case 'KO06' % KO06 pfkB
        Flux = [ 100, 52, 77, 77, 77, 163, 153, 49, 130, 47,...
            47, 25, 21, 14, 14, 11, 76, 76, 51, 43,...
            68, 68, 90, 0, 3, 25, 25, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 11, 4, 22, 29,...
            14, 9, 273, 0.83, 0.00, 0.00, 0.71, 0.00, 0.85, 0.28 ];
    case 'KO07' % KO07 fbp
        Flux = [ 100, 85, 87, 87, 87, 173, 162, 57, 142, 14,...
            14, 3, 11, 3, 3, 0, 82, 82, 52, 43,...
            73, 73, 95, 1, 8, 30, 30, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 11, 4, 23, 30,...
            15, 9, 257, 0.74, 0.94, 0.00, 0.66, 0.00, 0.93, 0.40 ];
    case 'KO08' % KO08 fbaB
        Flux = [ 100, 73, 83, 83, 83, 169, 159, 45, 123, 25,...
            25, 11, 14, 7, 7, 4, 80, 80, 67, 58,...
            71, 71, 85, 10, 0, 13, 13, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 11, 4, 22, 30,...
            14, 9, 263, 0.95, 0.00, 0.00, 0.58, 0.00, 0.91, 0.29 ];
    case 'KO09' % KO09 gapC
        Flux = [ 100, 63, 80, 80, 80, 168, 158, 54, 144, 36,...
            36, 19, 17, 11, 11, 8, 85, 85, 54, 46,...
            77, 77, 98, 0, 10, 31, 31, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 10, 4, 20, 27,...
            13, 8, 289, 0.90, 0.00, 0.00, 0.53, 0.00, 0.86, 0.25 ];
    case 'KO10' % KO10 gpmA
        Flux = [ 100, 83, 86, 86, 86, 172, 161, 41, 118, 16,...
            16, 5, 11, 4, 4, 1, 80, 80, 73, 64,...
            72, 72, 79, 16, 0, 7, 7, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 11, 4, 23, 30,...
            15, 9, 255, 0.94, 0.95, 0.01, 0.59, 0.01, 0.90, 0.31 ];
    case 'KO11' % KO11 gpmB
        Flux = [ 100, 88, 90, 90, 90, 178, 169, 55, 137, 11,...
            11, 3, 9, 3, 3, 0, 104, 104, 96, 89,...
            97, 97, 105, 11, 0, 8, 8, 0, 0, 0,...
            0, 1, 1, 6, 3, 1, 9, 3, 18, 25,...
            12, 7, 322, 0.82, 0.95, 0.00, 0.56, 0.00, 0.94, 0.46 ];
    case 'KO12' % KO12 pykA
        Flux = [ 100, 74, 84, 84, 84, 170, 160, 51, 129, 24,...
            24, 10, 14, 7, 7, 4, 83, 83, 65, 57,...
            74, 74, 92, 5, 0, 18, 18, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 11, 4, 22, 29,...
            14, 9, 270, 0.89, 0.84, 0.00, 0.67, 0.00, 0.93, 0.29 ];
    case 'KO13' % KO13 pykF
        Flux = [ 100, 47, 75, 75, 75, 161, 150, 46, 132, 52,...
            52, 29, 23, 16, 16, 13, 73, 73, 43, 34,...
            64, 64, 87, 0, 7, 30, 30, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 11, 4, 22, 29,...
            14, 9, 268, 0.87, 0.01, 0.00, 0.67, 0.00, 0.93, 0.28 ];
    case 'KO14' % KO14 ppsA
        Flux = [ 100, 68, 82, 82, 82, 170, 160, 35, 114, 31,...
            31, 15, 16, 9, 9, 6, 87, 87, 87, 79,...
            79, 79, 79, 21, 0, 0, 0, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 10, 4, 20, 27,...
            13, 8, 290, 0.92, 0.92, 0.00, 0.60, 0.00, 0.92, 0.33 ];
    case 'KO15' % KO15 zwf
        Flux = [ 100, 99, 93, 93, 93, 181, 171, 68, 156, 0,...
            0, -5, 5, -1, -1, -4, 103, 103, 76, 68,...
            95, 95, 115, 0, 7, 27, 27, 0, 0, 0,...
            0, 1, 1, 6, 3, 1, 9, 3, 19, 26,...
            12, 8, 307, 0.10, 0.91, 0.02, 0.47, 0.00, 0.93, 0.36 ];
    case 'KO16' % KO16 pgl
        Flux = [ 100, 78, 86, 86, 86, 173, 162, 51, 131, 20,...
            20, 8, 12, 6, 6, 3, 88, 88, 73, 65,...
            80, 80, 94, 7, 0, 15, 15, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 10, 4, 21, 28,...
            14, 8, 282, 0.92, 0.93, 0.00, 0.55, 0.00, 0.93, 0.25 ];
    case 'KO17' % KO17 gnd
        Flux = [ 100, 99, 93, 93, 93, 182, 173, 67, 149, 0,...
            0, -5, 5, -1, -1, -4, 108, 108, 93, 85,...
            101, 101, 117, 3, 0, 16, 16, 0, 0, 0,...
            0, 1, 1, 6, 3, 1, 9, 3, 18, 24,...
            12, 7, 324, 0.00, 0.95, 0.56, 0.06, 0.11, 0.81, 0.34 ];
    case 'KO18' % KO18 rpe
        Flux = [ 100, 92, 92, 92, 92, 181, 173, 70, 153, 7,...
            7, 0, 7, 1, 1, -1, 111, 111, 94, 87,...
            105, 105, 122, 0, 0, 17, 17, 0, 0, 0,...
            2, 1, 1, 5, 2, 1, 8, 3, 17, 23,...
            11, 7, 341, 0.00, 0.95, 0.71, 0.35, 0.08, 0.89, 0.26 ];
    case 'KO19' % KO19 rpiA
        Flux = [ 100, 67, 69, 69, 69, 157, 148, 45, 145, 31,...
            12, 3, 9, 3, 3, 0, 99, 99, 79, 72,...
            92, 92, 111, 0, 0, 20, 20, 20, 0, 0,...
            0, 1, 1, 6, 3, 1, 9, 3, 19, 26,...
            12, 8, 307, 0.33, 0.95, 0.45, 0.65, 0.17, 0.92, 0.41 ];
    case 'KO20' % KO20 rpiB
        Flux = [ 100, 51, 79, 79, 79, 169, 162, 52, 138, 48,...
            48, 28, 20, 15, 15, 13, 110, 110, 101, 95,...
            104, 104, 112, 7, 0, 8, 8, 0, 0, 0,...
            0, 1, 1, 5, 2, 1, 7, 3, 15, 20,...
            10, 6, 376, 0.94, 0.95, 0.94, 0.57, 0.16, 0.94, 0.39 ];
    case 'KO21' % KO21 tktA
        Flux = [ 100, 78, 79, 79, 79, 171, 164, 48, 147, 21,...
            8, 2, 6, 2, 2, 0, 129, 129, 129, 123,...
            123, 123, 123, 14, 0, 0, 0, 13, 0, 0,...
            0, 1, 1, 4, 2, 1, 7, 2, 14, 18,...
            9, 5, 393, 0.87, 0.95, 0.00, 0.42, 0.00, 0.84, 0.36 ];
    case 'KO22' % KO22 tktB
        Flux = [ 100, 86, 88, 88, 88, 175, 165, 40, 120, 13,...
            13, 3, 10, 3, 3, 0, 92, 92, 92, 84,...
            84, 84, 84, 21, 0, 0, 0, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 10, 4, 21, 28,...
            13, 8, 287, 0.94, 0.95, 0.00, 0.63, 0.00, 0.94, 0.39 ];
    case 'KO23' % KO23 talA
        Flux = [ 100, 85, 87, 87, 87, 174, 163, 39, 117, 13,...
            13, 3, 10, 3, 3, 0, 86, 86, 83, 75,...
            77, 77, 79, 20, 0, 2, 2, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 11, 4, 22, 29,...
            14, 9, 268, 0.57, 0.95, 0.00, 0.62, 0.02, 0.93, 0.48 ];
    case 'KO24' % KO24 talB
        Flux = [ 100, 86, 88, 88, 88, 175, 165, 41, 121, 13,...
            13, 3, 10, 3, 3, 0, 91, 91, 89, 81,...
            83, 83, 85, 20, 0, 2, 2, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 10, 4, 21, 28,...
            14, 8, 283, 0.38, 0.95, 0.00, 0.45, 0.02, 0.93, 0.39 ];
        
    case 'GR01' % GR01 WT, 0.1h-1
        Flux = [ 100, 62, 80, 80, 80, 167, 157, 53, 136, 36,...
            36, 19, 18, 11, 11, 8, 82, 82, 56, 48,...
            74, 74, 96, 0, 4, 26, 26, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 10, 4, 21, 28,...
            14, 8, 281, 0.95, 0.95, 0.01, 0.65, 0.06, 0.94, 0.30 ];
         %}            
   case 'GR02' % GR02 WT, 0.4h-1
        Flux = [ 5.05, 3.1815, 3.9895, 3.9895, 3.9895, 8.3325, 7.7265, 1.2625, 5.1005, 1.818,...
             1.818, 0.909, 0.909, 0.5555, 0.5555, 0.3535, 3.535, 3.535, 3.535, 3.03,...
             3.03, 3.03, 3.03, 1.2625, 0, 0, 0, 0, 0, 0,...
             0, 0.101, 0.0505, 0.404, 0.1515, 0.0505, 0.5555, 0.202, 1.212, 1.5655,...
             0.7575, 0.4545, 12.2715, 0.047975, 0.047975, 0.004545, 0.02626, 0.00606, 0.047975, 0.018685 ];
        
    case 'GR03' % GR03 WT, 0.5h-1
        Flux = [ 6.63, 5.5029, 5.7681, 5.7681, 5.7681, 11.4699, 10.7406, 2.2542, 7.4256, 0.9945,...
             0.9945, 0.2652, 0.7293, 0.2652, 0.2652, 0, 4.7736, 4.7736, 4.7736, 4.1769,...
             4.1769, 4.1769, 4.1769, 1.5912, 0, 0, 0, 0, 0.4641, 0,...
             0.1326, 0.1326, 0.0663, 0.4641, 0.1989, 0.0663, 0.7293, 0.2652, 1.5249, 1.989,...
             0.9945, 0.5967, 15.7794, 0.061659, 0, 0.004641, 0.035802, 0.000663, 0.057681, 0.00663 ];
            
    case 'GR04' % GR04 WT, 0.7h-1
        Flux = [13.34, 7.4704, 10.672, 10.672,10.672, 22.678, 21.6108, 5.7362, 16.9418, 5.6028,...
             5.6028, 3.2016, 2.4012, 1.7342, 1.7342, 1.4674, 11.8726, 11.8726, 11.8726, 11.0722,...
             11.0722, 11.0722, 11.0722, 2.2678, 0, 0, 0, 0, 1.8676, 0,...
             0.1334, 0.1334, 0.1334, 0.667, 0.2668, 0.1334, 1.0672, 0.4002, 2.1344, 2.8014,...
             1.334, 0.8004, 43.355, 0.12673, 0.12673, 0, 0.045356, 0, 0.125396, 0.030682 ];   
           
    case 'RF03' % RF03 WT(Jun)
        Flux = [ 3.28, 2.8536, 2.9192, 2.9192, 2.9192, 5.8384, 5.5432, 1.5744, 4.264, 0.3608,...
             0.3608, 0.0984, 0.2952, 0.0984, 0.0984, 0, 3.3456, 3.3456, 3.28, 3.0176,...
             3.116, 3.116, 3.1816, 0.5576, 0, 0.0656, 0.0656, 0, 0, 0,...
             0, 0.0328, 0.0328, 0.1968, 0.0984, 0.0328, 0.2952, 0.0984, 0.6232, 0.82,...
             0.3936, 0.2296, 10.3648, 0.0164, 0.03116, 0, 0.022304, 0, 0.03116, 0.01148 ];
        

    case 'RF05' % RF05 WT(Sep)
        Flux = [ 2.86, 2.288, 2.4596, 2.4596, 2.4596, 4.9478, 4.6332, 1.3156, 3.575, 0.5148,...
             0.5148, 0.2002, 0.3432, 0.143, 0.143, 0.0572, 2.4596, 2.4596, 2.1736, 1.9448,...
             2.2308, 2.2308, 2.4882, 0.3718, 0, 0.286, 0.286, 0, 0, 0,...
             0,0.0572, 0.0286, 0.2002, 0.0858, 0.0286, 0.286, 0.1144, 0.6006, 0.8294,...
             0.4004, 0.2288, 7.865, 0.02717, 0.02717, 0, 0.016874, 0, 0.026598, 0.010582 ];
             
    case 'RF06' % RF06 WT(Oct)
        Flux = [ 2.67, 1.602, 2.1093, 2.1093, 2.1093, 4.3788, 4.0851, 1.3083, 3.3642, 1.0413,...
             1.0413, 0.534, 0.5073, 0.3204, 0.3204, 0.2136, 1.9224, 1.9224, 1.3083, 1.068,...
             1.6821, 1.6821, 2.2962, 0, 0, 0.6141, 0.6141, 0, 0, 0,...
             0, 0.0534, 0.0267, 0.1869, 0.0801, 0.0267, 0.2937, 0.1068, 0.6141, 0.8277,...
             0.4005, 0.2403, 6.7284, 0.018156, 0.025365, 0, 0.022161, 0, 0.020025, 0.009078 ];
    
   case 'DeltaPpc' % 
        %Modeling and simulation of the main metabolism in Escherichia coli and its
        %several single-gene knockout mutants with experimental verification
        % Kadir et al., Microbial Cell Factories 2010, 9:88.
        % Dppc, D=0.2h-1.
                Flux = [100, 83.9, 89.4, NaN, 178.8, 178.8, 168.2, 60.6, 131.6, 15.1,...
                        15.1, 6.5, 8.6, 3.6, 3.6, 2.9, 96.7, 96.7, 77.8, 77.8,...
                        89.5, 89.5, 108.5, 0, 0, 18.9, 18.9, 0, 0, 0,...
                        0, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN,... 
                        NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN];
   case 'WT_C02'
                Flux = [100, 72.2, 84.1, 0, 168.2, 168.2, 160.2, 21.1, 97.1, 26.8,...
                        26.8, 12.9, 13.9, 8.9, 8.9, 4, 63.1, 63.1, 63.1, 63.1,...
                        53.1, 53.1, 53.1, 50.7, 0,  0, 0, 0, 18, 0,...
                        0, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN,... 
                        NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN, NaN];
         
    otherwise
        
        fprintf('Unexpected SampleID!\n');
end


    
