%##########################################################################
% Main metabolism of E.coli for the wild type (WT) in the batch
% Culture(BC)
% this model based on kinetic equation as stated in the comments below.
% version 1- updated on 29 MAC 2010
%##########################################################################

clc
clear all;
format short g
parameter_ori; % load kinetic parameters used in the equations
initialCons;    % load initial concentrations for all metabolites

long= 20;
time =[0:0.01:long];  % time for running this simulation
global POrate;
global k_ATP;
global Xm;
k_ATP =0.11;  %0.09 for pgi mutant
POrate =2.5;  %2.5
Xm =2.3;  %2.5

%set the initial condition
init_C1=[cX cGLCex cG6P cF6P cFDP cGAPDHAP cPEP cPYR cACCOA cICIT c2KG cSUC cFUM cMAL cOAA cGOX cACP cACET c6PG cRu5P cR5P cXu5P cS7P cE4P ]; 
[t,C1]=ode15s(@WTBC_ode, time, init_C1); %//CALL ODE23S AND FUNCTION PJT1_odefunction

NUM =size(C1);
for i=1:NUM
    if C1(i) <0.0
        C1(i)=0.0;
    end
end

% assinging ODE result to each metabolites as below: 
% purpose for assigning the value is to plotting it in graphs
X       = C1(:,1); 
GLCex   = C1(:,2);
G6P     = C1(:,3);
F6P     = C1(:,4);
FDP     = C1(:,5);
GAPDHAP = C1(:,6);
PEP     = C1(:,7);
PYR     = C1(:,8);
ACCOA   = C1(:,9); 
ICIT    = C1(:,10);
C2KG    = C1(:,11);
SUC     = C1(:,12);
FUM     = C1(:,13);
MAL     = C1(:,14);
OAA     = C1(:,15);
GOX     = C1(:,16); 
ACP     = C1(:,17); 
ACET    = C1(:,18); 
C6PG    = C1(:,19);
Ru5P    = C1(:,20);
R5P     = C1(:,21);
Xu5P    = C1(:,22);
S7P     = C1(:,23);
E4P     = C1(:,24);


%==========================================================================
% Plotting the simulation data (METABOLITES)for Batch Culture  (WILD TYPE)
% simulation result based on ODE23s
%==========================================================================
gCR_gl = 180/1000 ; % glucose change rate form mM to g/L 
acetCR_gl = 60/1000;
figure(1),clf;
subplot(331), plot(t,X,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(g/L)'),title('Cell concentration');
subplot(332), plot(t,GLCex*gCR_gl,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(g/L)') ,title('GLCex'); %,axis([0 40 0 5]);
subplot(333), plot(t,G6P,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM)') ,title('G6P');
subplot(334), plot(t,F6P,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM)') ,title('F6P');
subplot(335), plot(t,FDP,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM')  ,title('FDP');
subplot(336), plot(t,GAPDHAP,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM)') ,title('GAPDHAP');
subplot(337), plot(t,PEP,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM)') ,title('PEP');
subplot(338), plot(t,PYR,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM)') ,title('PYR');%,axis([0 20 0 10]);
subplot(339), plot(t,ACCOA,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM)') ,title('ACCOA');%,axis([0 20 0 10]);
set(gcf, 'color', 'white');
set(gcf, 'InvertHardCopy', 'off');

figure(2),clf;
subplot(331), plot(t,ICIT,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(g/L)'),title('Iso-citrate');
subplot(332), plot(t,C2KG,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(g/L)') ,title('2KG'); %,axis([0 40 0 5]);
subplot(333), plot(t,SUC,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(g/L)') ,title('Succinate'); %,axis([0 40 0 5]);
subplot(334), plot(t,FUM,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM)') ,title('Fumarate');
subplot(335), plot(t,MAL,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM)') ,title('Malate');
subplot(336), plot(t,OAA,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM')  ,title('Oxalacetate');
subplot(337), plot(t,GOX,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM)') ,title('Glyoxylate');%,axis([0 20 0 10]);
subplot(338), plot(t,ACP,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM)') ,title('Acetyl-Phosphate');
subplot(339), plot(t,ACET*acetCR_gl,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(g/L)') ,title('Acetate');
set(gcf, 'color', 'white');
set(gcf, 'InvertHardCopy', 'off');

figure(3),clf;
subplot(331), plot(t,C6PG,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(g/L)'),title('6PG');
subplot(332), plot(t,Ru5P,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(g/L)') ,title('Ru5P'); 
subplot(333), plot(t,R5P,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(g/L)') ,title('R5P'); 
subplot(334), plot(t,Xu5P,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM)') ,title('Xu5P');
subplot(335), plot(t,S7P,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM)') ,title('S7P');
subplot(336), plot(t,E4P,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM')  ,title('E4P');
set(gcf, 'color', 'white');
set(gcf, 'InvertHardCopy', 'off');

figure(4),clf;
plot(t,X,'r-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(g/L)'),title('Cell concentration');
hold on, plot(t,GLCex*gCR_gl,'b-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(g/L)') ,title('GLCex');
hold on, plot(t,ACET*acetCR_gl,'g-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(g/L)') ,title('Acetate');
axis([0 13 0 5]);
set(gcf, 'color', 'white');
set(gcf, 'InvertHardCopy', 'off');


%==========================================================================
% Plotting the simulation data (FLUXES)for Batch Culture  (WILD TYPE)
% simulation result based on ODE23s
%==========================================================================
sz= size(C1);
m = sz(1,1);
n = sz (1,2);
DataMetabolite = C1(m, 1:n);

sum1=0;
sum2=0;
sum3=0;
sum4=0;
for k=1:length(t),      
    X       = C1(k,1); 
    GLCex   = C1(k,2);
    G6P     = C1(k,3);
    F6P     = C1(k,4);
    FDP     = C1(k,5);
    GAPDHAP = C1(k,6);
    PEP     = C1(k,7);
    PYR     = C1(k,8);
    ACCOA   = C1(k,9); 
    ICIT    = C1(k,10);
    C2KG    = C1(k,11);
    SUC     = C1(k,12);
    FUM     = C1(k,13);
    MAL     = C1(k,14);
    OAA     = C1(k,15);
    GOX     = C1(k,16); 
    ACP     = C1(k,17); 
    ACET    = C1(k,18); 
    C6PG    = C1(k,19);
    Ru5P    = C1(k,20);
    R5P     = C1(k,21);
    Xu5P    = C1(k,22);
    S7P     = C1(k,23);
    E4P     = C1(k,24);
    
r_PTS(k)   = (V_PTSmax*GLCex*PEP/PYR)/( (K_PTSa1+(K_PTSa2*PEP/PYR)+(K_PTSa3*GLCex)+(GLCex*PEP/PYR)) * (1 + (G6P^n_PTSg6p/K_PTSg6p)) );
r_PGI(k)   = (V_PGImax*(G6P-(F6P/K_PGIeq)))/( K_PGIg6p* (1+(F6P/(K_PGIf6p*(1+C6PG/K_PGIf6p_6pginh)))+(C6PG/K_PGIg6p_6pginh))+ G6P );
%r_PGI(k)   = 0;
A = 1 + (PEP/K_PFKpep) + (ADP/K_PFKadp_b) + (AMP/K_PFKamp_b);
B = 1 + (ADP/K_PFKadp_a) + (AMP/K_PFKamp_b);
r_PFK(k) = (V_PFKmax*ATP*F6P)/((ATP+K_PFKatp_s*(1+ADP/K_PFKadp_c))*(F6P+K_PFKf6p_s*(A/B))*(1+L_PFK/(1+F6P*(B/(K_PFKf6p_s*A)))^n_PFK ) );  %original kinetic equation
%r_PFK(k) = (V_PFKmax*ATP*F6P)/( (ATP+K_PFKatp_s*(1+ADP/K_PFKadp_c))*(F6P+K_PFKf6p_s*(A/B)) );
r_ALDO(k)  =(V_ALDOmax*FDP-(GAPDHAP/K_ALDOeq))/(K_ALDOfdp+FDP+((K_ALDOgap*GAPDHAP)/(K_ALDOeq*V_ALDOblf))+((K_ALDOdhap*GAPDHAP)/(K_ALDOeq*V_ALDOblf))+(FDP*GAPDHAP/K_ALDOgapinh)+(GAPDHAP/(K_ALDOeq*V_ALDOblf)));
%r_ALDO(k)  =(V_ALDOmax*FDP-(GAPDHAP*GAPDHAP/K_ALDOeq))/(K_ALDOfdp+FDP+((K_ALDOgap*GAPDHAP)/(K_ALDOeq*V_ALDOblf))+((K_ALDOdhap*GAPDHAP)/(K_ALDOeq*V_ALDOblf))+(FDP*GAPDHAP/K_ALDOgapinh)+(GAPDHAP*GAPDHAP/(K_ALDOeq*V_ALDOblf)));
r_GAPDH(k) =(V_GAPDHmax*(GAPDHAP-((PEP*NADH)/(K_GAPDHeq*NAD))))/((K_GAPDHgap*(1+(PEP/K_GAPDHpgp))+GAPDHAP)*((K_GAPDHnad/NAD)*(1+(NADH/K_GAPDHnadh))+1));
r_PYK(k)   =(V_PYKmax*PEP*(((PEP/Km_PYKpep)+1)^n_PK)*ADP)/(Km_PYKpep*(L_PYK *(((1+ATP/Km_PYKatp)/((FDP/Km_PYKfdp)+(AMP/Km_PYKamp)+1))^n_PYK)+((PEP/Km_PYKpep +1)^n_PYK))*(ADP +Km_PYKadp));
r_PDH(k)   = (V_PDHmax2*(1/(NAD+(Ki_PDH2*NADH)))*(PYR/Km_PDHpyr2)*(NAD/Km_PDHnad2)*(COA/Km_PDHcoa2))/((1+(PYR/Km_PDHpyr2))*((1/NAD)+(1/Km_PDHnad2)+(NADH/(NAD*Km_PDHnadh2)))*(1+(COA/Km_PDHcoa2)+(ACCOA/Km_PDHaccoa2)));
%r_CS(k)    =(CSmax*ACCOA*OAA)/(((Kd_CSaccoa*Km_CSoaa+Km_CSaccoa*OAA)*(1+ATP/Ki_CSatp))+(ACCOA*Km_CSoaa*(1+(C2KG/Ki1_CS2kg)+(NADH/Ki1_CSnadh)))+(ACCOA*OAA*(1+(C2KG/Ki2_CS2kg)+(NADH/Ki2_CSnadh))));
pH=7.0;
H=10^((-1)*pH);
r_CS(k) = (V_CSmax*(1+(Kd1_CSh/H)+(H/Kd2_CSh))*ACCOA*OAA) / (((Kd_CSaccoa*Km_CSoaa+Km_CSaccoa*OAA)*(1+(Kd1_CSh/H)+((H/Kd2_CSh)*(1+ATP/Ki_CSatp)))) + (ACCOA*Km_CSoaa*(1+(Kd1_CSh/H)+(H/Kd2_CSh)+(C2KG/Ki1_CS2kg)+(NADH/Ki1_CSnadh)))+(ACCOA*OAA*(1+(Kd1_CSh/H)+(H/Kd2_CSh)+(C2KG/Ki2_CS2kg)+(NADH/Ki2_CSnadh))));
r_ICDH(k)  =(ICDH*(Kf_ICDH/Km_ICDHicit)*Kd_ICDHnadp*(ICIT-(NADPH*C2KG/(Keq_ICDH*NADP))))/((1/NADP)+(ICIT*Km_ICDHnadp/(Km_ICDHicit*Kd_ICDHnadp*NADP))+(1/Kd_ICDHnadp)+(ICIT/(Km_ICDHicit*Kd_ICDHnadp))+((ICIT/(Kd_ICDHicit*NADP))*((NADPH*Km_ICDHnadp)/(Km_ICDHicit*Kd_ICDHnadp*Keinh_ICDHnadph)))+((NADPH*Keknh_ICDH2kg)/(Km_ICDH2kg*Kenhe_ICDHnadph*NADP))+((C2KG*Km_ICDHnadph)/(Km_ICDH2kg*Kenhe_ICDHnadph*NADP))+((C2KG/Km_ICDH2kg)*(NADPH/(Kenhe_ICDHnadph*NADP)))+ (((C2KG*Km_ICDHnadph)/(Km_ICDH2kg*Kenhe_ICDHnadph))*(NADPH/(Kekn_ICDHnadp*NADP))));
r_2KGDH(k) =(V_2KGDHmax*C2KG*COA)/( ((K_2KGDHnad*C2KG*COA)/NAD)+(K_2KGDHcoa*C2KG)+(K_2KGDH2kg*COA)+(C2KG*COA)+((K_2KGDH2kg*K_2KGDHz*SUC*NADH)/(K_2KGDHsuc*NAD))+((K_2KGDHnad*C2KG*COA*NADH)/(K_2KGDHnadh*NAD))+ ((K_2KGDHcoa*C2KG*SUC)/K_2KGDHsuc)+((K_2KGDH2kg*K_2KGDHz*C2KG*SUC*NADH)/(KI_2KGDH2kg*K_2KGDHsuc*NAD)) );
r_SDH(k)   =(V_SDH1*V_SDH2*(SUC-(FUM/Keq_SDH)))/((Km_SDHsuc*V_SDH2)+(V_SDH2*SUC)+(V_SDH1*FUM/Keq_SDH));
r_FUM(k)   =(V_FUM1*V_FUM2*(FUM-(MAL/Keq_FUM)))/((Km_FUM*V_FUM2)+(V_FUM2*FUM) + (V_FUM1*MAL/Keq_FUM)); 
r_MDH(k)   =(V_MDH1*V_MDH2*(MAL-(OAA/Keq_MDH)))/( ((KI_MDHnad*Km_MDHmal*V_MDH2)/NAD) + (Km_MDHmal*V_MDH2)+((Km_MDHnad*V_MDH2*MAL)/NAD)+ (V_MDH2*MAL)+((Km_MDHoaa*V_MDH1*NADH)/(Keq_MDH*NAD))+ ((Km_MDHnadh*V_MDH1*OAA)/(Keq_MDH*NAD))+((V_MDH1*NADH*OAA)/(Keq_MDH*NAD))+((V_MDH1*Km_MDHoaa*NADH)/(Keq_MDH*KI_MDHnad))+((V_MDH2*Km_MDHnad*MAL*OAA)/(KI_MDHoaa*NAD))+((V_MDH2*MAL*NADH)/KI_MDHnadh)+((V_MDH1*MAL*NADH*OAA)/(Keq_MDH*KI_MDHmal*NAD))+((V_MDH2*MAL*OAA)/KII_MDHoaa)+((V_MDH1*NADH*OAA)/(KII_MDHnad*Keq_MDH))+((KI_MDHnad*V_MDH2*MAL*NADH*OAA)/(KII_MDHnad*Km_MDHoaa*KI_MDHnadh))) ; 
%r_ICL(k)   =(r_ICLmax_f*(ICIT/K_ICLicit))/(1+(ICIT/K_ICLicit)+(SUC/K_ICLsuc)+(GOX/K_ICLgox)+((ICIT/K_ICLicit)*(SUC/K_ICLsuc))+((SUC/K_ICLsuc)*(GOX/K_ICLgox))+(I/KI_ICL));
r_ICL(k) = (V_ICLmax*(ICIT/K_ICLicit)) / ((1+(ICIT/K_ICLicit))*(1+(SUC/K_ICLsuc)+(PEP/K_ICLpep)+(C2KG/K_ICL2kg)));
r_MS(k)    =(Vf_MS*(GOX/Km_MSgox)*(ACCOA/Km_MSaccoa))/((1+(GOX/Km_MSgox) +(MAL/Km_MSmal))*(1+ACCOA/Km_MSaccoa));
r_PTA(k)   =(V_PTAmax*(1/(Ki_PTAaccoa*Km_PTAp))*((ACCOA*P)-(ACP*COA/Keq_PTA)))/(1+(ACCOA/Ki_PTAaccoa)+(P/Ki_PTAp)+(ACP/Ki_PTAacp)+(COA/Ki_PTAcoa)+((ACCOA*P)/(Ki_PTAaccoa*Km_PTAp))+((ACP*COA)/(Km_PTAacp*Ki_PTAcoa))); 
r_ACK(k)   =(V_ACKmax*(1/Km_ACKadp*Km_ACKacp)*((ACP*ADP)-(ACET*ATP/Keq_ACK)))/( (1+(ACP/Km_ACKacp)+(ACET/Km_ACKacet))*(1+(ADP/Km_ACKadp)+(ATP/Km_ACKatp)) );
r_ACS(k)   = (V_ACSmax*ACET*NADP)/(Km2_ACS+ACET)*(Keq_ACS+NADP);
%r_ACS(k)   = V_ACSmax*ACET/(Km2_ACS+ACET);
r_MEZ(k)   =(V_MEZ*MAL*NADP)/((Km_MEZmal+ MAL)*(Keq_MEZ+NADP));
r_PCK(k)   =(V_PCKmax*OAA*(ATP/ADP))/( (Km_PCKoaa*(ATP/ADP)) +(OAA*(ATP/ADP))+(Ki_PCKatp*Km_PCKoaa/Ki_PCKadp)+((Ki_PCKatp*Km_PCKoaa*PEP)/(Km_PCKpep*Ki_PCKadp))+((Ki_PCKatp*Km_PCKoaa/(Ki_PCKpep*KI_PCKatp))*(ATP*PEP/ADP))+((Ki_PCKatp*Km_PCKoaa)/(Ki_PCKadp*KI_PCKoaa)*OAA));
r_PPC(k)   = V_PPCmax2*((k1+(k2*ACCOA)+(k3*FDP)+(k4*ACCOA*FDP))/(1+(k5*ACCOA)+(k6*FDP)))*(PEP/(Km_PEP+PEP)); %Lee
%r_PPC(k)   =0;
r_G6PDH(k) = (V_G6PDHmax*G6P)/((G6P+K_G6PDHg6p)*(1+(NADPH/K_G6PDHnadphg6pinh))*((K_G6PDHnadp/NADP)*(1+NADPH/K_G6PDHnadphnadpinh)+1));
r_6PGDH(k) = (V_6PGDHmax*C6PG)/((C6PG+K_6PGDH6pg)*(1+(K_6PGDHnadp/NADP)*(1+(NADPH/K_6PGDHnadphinh))*(1+(ATP/K_6PGDHatpinh))));
r_RPE(k)  = V_RPEmax*(Ru5P-(Xu5P/K_RPEeq));
r_RPI(k)  = V_RPImax*(Ru5P-(R5P/K_RPIeq));
r_TKTA(k) = V_TKTAmax*((R5P*Xu5P)-(S7P*GAPDHAP/K_TKTAeq));
r_TKTB(k) = V_TKTBmax*((Xu5P*E4P)-(F6P*GAPDHAP/K_TKTBeq));
r_TAL(k)  = V_TALmax*((GAPDHAP*S7P)-(E4P*F6P/K_TALeq));
 
r_CO2(k) = r_PDH(k)+r_PCK(k)+r_ICDH(k)+r_2KGDH(k)+r_MEZ(k)+r_6PGDH(k)-r_PPC(k);
CO22(k)  = r_CO2(k)*X; 
OP_NADH(k) = (r_GAPDH(k)+r_PDH(k)+r_ICDH(k)+r_2KGDH(k)+r_MDH(k))*POrate;  %%%%2.5
OP_FADH(k) = r_SDH(k)*1.5;
r_ATP(k)   = OP_NADH(k)+OP_FADH(k)+r_GAPDH(k)+r_PYK(k)+r_ACK(k)+r_SDH(k)-r_PFK(k)-r_PCK(k);
totalATP(k)  = r_ATP(k)*X; 

sum1 =sum1+r_ATP(k);
sum_ATP(k)=sum1; 
sum2 =sum2+totalATP(k);
sum_totalATP(k)=sum1;

sum3 =sum3+r_CO2(k);
sum_CO2(k)=sum3;    
sum4 =sum4+CO22(k);
sum_totalCO2(k)=sum4;

n=1;
Sf=S_f*180/1000; 
miu(k)  =miu_Max*((1-X/Xm)^n)*((GLCex*180/1000)/(K_Xs+GLCex*180/1000))*k_ATP*r_ATP(k); 
%miu  =miu_Max*((1-X/(Sf/2.5))^1)*((GLCex*180/1000)/(K_Xs+GLCex*180/1000)); %%original

%% ----------------------------------------------------------------------
%% Include some rule based for Acetate Production and consumption
%% ----------------------------------------------------------------------
minGlc =3; % 1g/l=5.56mM
if ((GLCex<=minGlc) && (ACET>=0)) 
    miu(k)    =(miu_Max*((1-X/Xm)^n)*((ACET*60/1000)/(K_ACETs+ACET*60/1000))*k_ATP*r_ATP(k)) + ...
            (miu_Max*((1-X/Xm)^n)*((GLCex*180/1000)/(K_Xs+GLCex*180/1000))*k_ATP*r_ATP(k));  
    %miu     =(miu_Max*ACET*60/1000)/(K_ACETs+ACET*60/1000)*k_ATP*r_ATP; % *k_ATP*r_ATP
  	cra  = 1;   % cra activate
	fadR = 0;   % fadR repress
	iclR = 0;   % iclR repress
    r_ACS(k) = r_ACS(k)*(minGlc-GLCex); % Acs active    
    r_MEZ(k) = r_MEZ(k);
    r_PCK(k) = r_PCK(k);
    r_ACK(k) = r_ACK(k)*(GLCex/minGlc); %
    r_PTA(k) = r_PTA(k)*(GLCex/minGlc); %
else
    cra  = 0;   % cra repress
	fadR = 1;   % fadR actived
	iclR = 1;   % iclR actived
    r_ACS(k) = 0;  % Acs inactive  
    r_MEZ(k) = 0;  % mez inactive 
    r_PCK(k) = 0;  % pck inactive 
end

if (r_PPC(k)==0)
    r_ACK(k) = 0; %
    r_PTA(k) = 0; %
    cra  = 1;   % cra repress
	fadR = 0;   % fadR actived
	iclR = 0;   % iclR actived
end

if (cra==1)	
	aceA = 1;   % {Icl active}
    aceB = 1;   % {MS active}
elseif (cra==0)
	aceA = 0;   % {Icl repress}
    aceB = 0;   % {MS repress}
end

if ((fadR==0)&(iclR==0))
	aceA = 1; %   {Icl active}
	aceB = 1; %   {MS active}	
    aceK = 1; %   {ICDH repress}   
elseif ((fadR==1)&(iclR==1))
	aceA = 0; %   {Icl repress }
	aceB = 0; %   {MS repress }	
    aceK = 0; %   {ICDH active}   
end

%-----ICL -----------
if (aceA==1)
    r_ICL(k) = r_ICL(k); 
elseif (aceA==0)
    r_ICL(k) =0;
end

%------MS------------
if (aceB==1)
    r_MS(k) = r_MS(k);
elseif (aceB==0)
    r_MS(k)=0;
end

if (GLCex<=minGlc)
    r_ACK(k) = r_ACK(k)*(GLCex/minGlc); %
    r_PTA(k) = r_PTA(k)*(GLCex/minGlc); %
end
end

%figure
figure(5),clf;
subplot(4,3,1), plot(t,miu,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('(1/h)'),title('miu');
subplot(4,3,2), plot(t,r_PTS,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('PTS'),axis([0 20 0 5]);
subplot(4,3,3), plot(t,r_PGI,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('PGI');
subplot(4,3,4), plot(t,r_PFK,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('PFK');
subplot(4,3,5), plot(t,r_ALDO,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('ALDO');
subplot(4,3,6), plot(t,r_GAPDH,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('mmol/gh)'),title('GAPDH');
subplot(4,3,7), plot(t,r_PYK,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('PYK');
subplot(4,3,8), plot(t,r_PDH,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('PDH');
subplot(4,3,9), plot(t,r_CS,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('CS');%,axis([0 20 0 2]);
subplot(4,3,10), plot(t,r_ICDH,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('ICDH');
subplot(4,3,11), plot(t,r_2KGDH,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('2KGDH');
set(gcf, 'color', 'white');
set(gcf, 'InvertHardCopy', 'off');

%figure
figure(6),clf;
subplot(4,3,1), plot(t,r_ICL,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('ICL');
subplot(4,3,2), plot(t,r_MS,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('MS');%,axis([0 20 0 1]);
subplot(4,3,3), plot(t,r_SDH,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('SDH');
subplot(4,3,4), plot(t,r_FUM,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('FUM');
subplot(4,3,5), plot(t,r_MDH,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('MDH');%,axis([0 20 0 1]);
subplot(4,3,6), plot(t,r_PTA,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('PTA');
subplot(4,3,7), plot(t,r_ACK,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('ACK');
subplot(4,3,8), plot(t,r_ACS,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('ACS');
subplot(4,3,9), plot(t,r_PCK,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('PCK');
subplot(4,3,10), plot(t,r_PPC,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('PPC');
subplot(4,3,11), plot(t,r_MEZ,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('MEZ');%,axis([0 20 0 0.1]);
set(gcf, 'color', 'white');
set(gcf, 'InvertHardCopy', 'off');

%figure
figure(7),clf;
subplot(4,3,1), plot(t,r_G6PDH,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('G6PDH');
subplot(4,3,2), plot(t,r_6PGDH,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('6PGDH');
subplot(4,3,3), plot(t,r_RPE,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('RPE');
subplot(4,3,4), plot(t,r_RPI,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('RPI');%,axis([0 20 0 1]);
subplot(4,3,5), plot(t,r_TKTA,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('TKTA');
subplot(4,3,6), plot(t,r_TKTB,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('TKTB');
subplot(4,3,7), plot(t,r_TAL,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('TAL');
set(gcf, 'color', 'white');
set(gcf, 'InvertHardCopy', 'off');

%figure
figure(8),clf;
subplot(331), plot(t,r_CO2,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('Specific rate CO_2');
subplot(332), plot(t,r_ATP,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Rate(mmol/gh)'),title('Specific rate ATP');
subplot(334), plot(t,CO22,'k-','LineWidth',1.7),xlabel('time (h)'),ylabel('Concentration(mM)'),title('Total CO_2 production');
subplot(335), plot(t,totalATP,'k-','LineWidth',1.7), xlabel('time (h)'),ylabel('Concentration(mM)'),title('Total ATP production');
set(gcf, 'color', 'white');
set(gcf, 'InvertHardCopy', 'off');

    
%%======= END OF FLUXES PLOTTING ==========================================



% %==========================================================================
% % Plotting an experimental data for Batch Culture  (WILD TYPE)
% % updated on 29 march 2010
% % data source : Shimizu lab experimental Data (student name???) 
% %==========================================================================
% load Experiment1.dat; % load data for experimental data Wild Type batch culture
% Experiment1   % to list all data in WTexp
% time=Experiment1(:,1:1);
% biomass=Experiment1(:,2:2);
% glucose=Experiment1(:,3:3);
% acetate=Experiment1(:,4:4);
% 
% %---experimental data
% figure (4),
% hold on, plot(time,biomass,'rs','LineWidth',2,'MarkerEdgeColor','r','MarkerSize',7);
% hold on, plot(time,glucose,'bs','LineWidth',2,'MarkerEdgeColor','b','MarkerSize',7);
% hold on, plot(time,acetate,'gs','LineWidth',2,'MarkerEdgeColor','g','MarkerSize',7);


%==========================================================================
% plotting experimental dta for Batch Culture  (WILD TYPE)
% data source : Toya Data
%==========================================================================
load Experiment_toyaWT.dat; % load data for experimental data Wild Type batch culture
Experiment_toyaWT   % to list all data in WTexp
time=Experiment_toyaWT(:,1:1);
biomass=Experiment_toyaWT(:,2:2);
glucose=Experiment_toyaWT(:,3:3);
acetate=Experiment_toyaWT(:,4:4);

%---experimental data
figure (4);
hold on,plot(time,biomass,'ro','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','r','MarkerSize',9);
hold on,plot(time,glucose,'bs','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','b','MarkerSize',9);
hold on,plot(time,acetate,'gd','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','g','MarkerSize',9);


%==========================================================================
% Simulation and Experimental Data for Continuous Culture  (WILD TYPE)
% for DILUTION, NADP, NADPH1(G6PDH+6PGDH+MEZ), ATP, FADH, Total ATP, CO2, 
% NADPH2(G6PDH+6PGDH+MEZ+ICDH), NADPH3(G6PDH+6PGDH)
% data = Toya et al., Science 2007
% updated on 29 June 2010
% written by Tuty
%==========================================================================
load scienceData.dat; % load data for experimental data Wild Type con.culture
scienceData;   % to list all data in WTexp
dil=scienceData(1,:);
nadp=scienceData(2,:);
nadph1=scienceData(3,:); % inculde icdh
atp=scienceData(4,:);
fadh=scienceData(5,:);
totalATP=scienceData(6,:);
co2=scienceData(7,:);
nadph2=scienceData(8,:); % not inculde icdh
nadph3=scienceData(9,:); % not inculde icdh and mez
g6pdh=scienceData(10,:);

figure(9),clf;
%---simulation data
plot(dil,nadph2,'ks','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','k','MarkerSize',7);
xlabel('Dilution rate(1/h)'),ylabel('Specific NADPH production rate(mmol/gDCW.h)');
title('Specific NADPH production');        
set(gcf, 'color', 'white');
set(gcf, 'InvertHardCopy', 'off');  
axis([0 0.8 0 13]); % 25

figure(10),clf;
%---simulation data
plot(dil,totalATP,'ks','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','k','MarkerSize',7);
%hold on, plot(dil,dil*18.5);
xlabel('Dilution rate(1/h)'),ylabel('Specific ATP production rate(mmol/gDCW.h)');
title('Specific ATP production'); 
set(gcf, 'color', 'white');
set(gcf, 'InvertHardCopy', 'off'); 
axis([0 0.8 0 250]);

figure(11),clf;
%---simulation data
plot(dil,g6pdh,'bs','LineWidth',2,'MarkerEdgeColor','b','MarkerFaceColor','b','MarkerSize',7);
xlabel('Dilution rate(1/h)'),ylabel('Specific rate(mmol/gDCW.h)');
title('G6PDH flux'); 
set(gcf, 'color', 'white');
set(gcf, 'InvertHardCopy', 'off');
axis([0 0.6 0 3]);



load yangchen.dat; % load data for experimental data Wild Type con.culture
yangchen;   % to list all data in WTexp
dil2=yangchen(1,:);
nadp2=yangchen(2,:);
fadh2=yangchen(3,:);
atp2=yangchen(4,:);
totalATP2=yangchen(5,:);
g6pdh2=yangchen(6,:);
nadph21=yangchen(7,:);  % not inculde icdh
nadph22=yangchen(7,:); % inculde icdh

x=[0:0.01:0.8];
figure(9);
%---simulation data
hold on, plot(dil2,nadph21,'ko','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','k','MarkerSize',7);
hold on, plot(x,x*9,'k-','LineWidth',1.5);  %x*13.6  x*9
legend('Ishii','Yang Chen');  

x2=[0:0.01:0.8];
figure(10);
%---simulation data
hold on, plot(dil2,totalATP2,'ko','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','k','MarkerSize',7);
hold on, plot(x2,x2*190,'k-','LineWidth',1.5);  %%x2*197.6
%hold on, plot(miu,r_ATP,'b-');
legend('Ishii','Yang Chen');    

figure(11);
%---simulation data
hold on, plot(dil2,g6pdh2,'bo','LineWidth',2,'MarkerEdgeColor','b','MarkerFaceColor','b','MarkerSize',7);
legend('Ishii','Yang Chen');  

figure(12),clf;
%---simulation data
subplot(2,1,1), plot(t,sum_ATP*0.01,'b-','LineWidth',2,'MarkerEdgeColor','b','MarkerFaceColor','b','MarkerSize',7),title('Specific ATP production'); 
legend('Specific ATP production');  
subplot(2,1,2), plot(t,sum_totalATP*0.01,'b-','LineWidth',2,'MarkerEdgeColor','b','MarkerFaceColor','b','MarkerSize',7),title('Total ATP production');
legend('Total ATP production');  

figure(13),clf;
%---simulation data
subplot(2,1,1), plot(t,sum_CO2*0.01,'b-','LineWidth',2,'MarkerEdgeColor','b','MarkerFaceColor','b','MarkerSize',7),title('Specific CO2 production'); 
legend('Specific CO2 production');  
subplot(2,1,2),hold on, plot(t,sum_totalCO2*0.01,'b-','LineWidth',2,'MarkerEdgeColor','b','MarkerFaceColor','b','MarkerSize',7),title('Total C02 production'); 
legend('Total CO2 production');  

figure(14),clf;
%---simulation data
hold on, plot(miu,sum_ATP*0.01,'b-');
xlabel('miu-Dilution(1/h)'),ylabel('Specific ATP production');
legend('miu vs specific ATP'); 
