%##########################################################################
% List of ALL Parameters 
% using original parameter
% updated on 29 MAC 2010
%##########################################################################
%--------------------------------------------------------------------------
%----Initial Values for Co-Factor-----------------------------
%--------------------------------------------------------------------------
NAD  =1.47;
NADH =0.1;
NADP =0.195;
NADPH=0.062;
COA  =0.001;
ADP  =0.595;  
ATP  =4.27;   
AMP  =0.955; 
H    =0.001;
P    =10;

%--------------------------------------------------------------------------
%     parameter for BIOMASS,X and related
%--------------------------------------------------------------------------
miu_Max =0.6;  %0.57;
K_Xs    =0.1;  %0.1(ppc); 2(pyk)
K_ACETs =0.01;  %0.01(ppc); 0.1(pyk)
D =0.4;

Px      =564 ;
Y       =0.5;
S_f     =4.56*(1000/180);  % unit in mM, 27.8mM = 5g/L 4.56

%##########################################################################
%      GLYCOLYSIS  PATHWAYS      
%##########################################################################
%----parameter for PTS---------(chasagnole,2002)---------------------------
V_PTSmax =25.739; % //original parameter  25.739*100;
K_PTSa1  =1;  %  original=1
K_PTSa2  =0.01;
K_PTSa3  =1;
n_PTSg6p =4; %original=4
K_PTSg6p =0.5; 

%----parameter for PGI-------(chasagnole,2002)-----------------------------
V_PGImax =26.3711;  %26.3711*10;  original 6.3711
K_PGIg6p = 2.46;
K_PGIf6p =0.2;
K_PGIeq =0.43;
K_PGIg6p_6pginh =0.2;
K_PGIf6p_6pginh =0.2;

%----parameter for PFK-------(chasagnole,2002)-----------------------------
V_PFKmax =24.613; %24.613 ; %  //original parammeter
K_PFKatp_s =0.16; 
K_PFKadp_a =239; 
K_PFKadp_b =0.25; 
K_PFKadp_c =0.36; 
K_PFKamp_a =8.74; 
K_PFKamp_b =0.01;
n_PFK =4; % original n_PFK
L_PFK =4;   % original - 4000000;
K_PFKf6p_s =0.14;  
K_PFKpep =3.26;

%----parameter for ALDO-------(chasagnole,2002)----------------------------
V_ALDOmax = 2.8337;  % 2.8337 %64.461;  //original parameter 
K_ALDOfdp=0.133;   
K_ALDOgap =0.088;
K_ALDOdhap =0.088;
K_ALDOgapinh =0.6;
K_ALDOeq =0.14;  
V_ALDOblf =2;  


%----parameter for GAPDH-------(chasagnole,2002)---------------------------
V_GAPDHmax =121.29;%(ori    121.29
K_GAPDHgap =0.15;
K_GAPDHpgp = 0.1; 
K_GAPDHnad =0.45;
K_GAPDHnadh =0.02;
K_GAPDHeq =0.63;

%----parameter for PYK-------(chasagnole,2002)-----------------------------
V_PYKmax  =1.085; %1.085*2-ori
Km_PYKpep =0.31; %0.31;
Km_PYKfdp =0.19;
Km_PYKamp =0.2;
Km_PYKatp =22.5;
Km_PYKadp =0.26;
L_PYK =1000;
n_PYK=4;  
n_PK=n_PYK-1;

%----parameter for PDH version 2(hoefnagel,2002)-------
V_PDHmax2    =27171; %  27171
Km_PDHpyr2   =1;
Km_PDHnad2   =0.4;
Km_PDHcoa2   =0.014;
Km_PDHaccoa2 =0.008;
Km_PDHnadh2  =0.1;
Ki_PDH2      =46.4; 

%----parameter for PDH-------(chasagnole,2002)-----------------------------
V_PDHmax = 1.8074; %1.2666  ;% (ori-0.19378mM/s) original parameter  
K_PDHpyr = 0.11;
n_PDH = 1;

%##########################################################################
%#          PENTOSE PHOSPATE  PARAMETER                                   #
%##########################################################################
%----parameter for G6PDH--(chasagnole,2002)-----
V_G6PDHmax = 0.97922;  %ori- 0.97922*50   6.7311
K_G6PDHnadp =0.015;%  14.4; % 0.015;%  
K_G6PDHnadphnadpinh = 0.01; 
K_G6PDHnadphg6pinh = 0.18; 
K_G6PDHg6p = 0.07; 

V_6PGDHmax =1.81;
K_6PGDH6pg  = 0.1;
K_6PGDHnadp  = 0.028;
K_6PGDHnadphinh  = 0.01;
K_6PGDHatpinh = 3.0;

V_RPEmax = 18.486;
K_RPEeq = 1.4;

V_RPImax = 13.319;
K_RPIeq = 4.0;

V_TKTAmax = 29.348;
K_TKTAeq = 1.2;

V_TKTBmax = 316.22;
K_TKTBeq = 10;

V_TALmax = 24.499;
K_TALeq = 1.05;

%##########################################################################
%          TCA CYCLE PATHWAYS 
%##########################################################################
%----parameter for CS version 1 (E.A.Mogilevskaya)-------------------------
V_CSmax= 34.7244/2; 
CSmax= 34.7244*2; % 1.0675 26.427
 Km_CSaccoa =0.18;
 Km_CSoaa= 0.04;  %0.04;
 Kd_CSaccoa =0.1; %0.1;
 Kd1_CSh = 1e-5; %0.00001
 Kd2_CSh = 2e-4; %0.0002; 
 Ki_CSatp = 0.58;
 Ki1_CS2kg=0.015;
 Ki2_CS2kg=0.256;
 Ki1_CSnadh=3.3e-4; %0.00033;
 Ki2_CSnadh= 8.4e-3; %0.0084
 H = 10^(-7.0);
 K_cat0 =1; %1;  %9941/60; %4860*60
 
 %----parameter for CS version 2 (barbara wright)--------
 V_CSmax2	= 1.0645;  
 Km_CSaccoa2 = 0.01;
 Km_CSoaa2 = 0.007;
 Ki_CScoa2= 0.11;
% %  
%----parameter for ICDH version 1 (E.A.Mogilevskaya)-----------------------                      
ICDH = 1.8785*13; %1.8785*13;
Keq_ICDH = 1000;   %ori-1000
Kf_ICDH = 4830*60; %4830*60;
Km_ICDH2kg = 0.038;
Km_ICDHco2 = 2.2;
Km_ICDHicit = 0.011; %0.0059;
Kd_ICDHnadp = 0.006; %0.0013;
Km_ICDHnadp = 0.017; %0.0227;
Kd_ICDHnadph = 0.00014 ; % (0.00014 T=21; 0.12 T=37, T=degree)
Kd_ICDHicit = 0.003; % (0.0003 T=21; 0.03 T=37, T=degree)
Keinh_ICDHnadph = 7e-3;%0.007;
Keknh_ICDH2kg = 5.5;
Kd_ICDHco2 = 1.6;
Keke_ICDHco2 = 1.6;
Kekn_ICDHnadp = 1.6e-4; %0.00016;
Km_ICDHnadph = 0.0036;
Kenhe_ICDHnadph = 0.028;

%----parameter for 2KGDH---------------------------------------------------                                                                                                    
V_2KGDHmax=149.74/4; % 149.74/4;  
K_2KGDH2kg=1.0;
KI_2KGDH2kg=0.75;
K_2KGDHcoa=0.002;
K_2KGDHnad=0.07;
K_2KGDHsuc=1.0;
K_2KGDHnadh=0.018;
K_2KGDHz=1.5;

%----parameter for SDH-----------------------------------------------------
Km_SDHsuc=0.1;
V_SDH1=1.1334;
V_SDH2= 1.1334; 
Keq_SDH=10;  

%----parameter for FUM version1--------------------------------------------
Km_FUM= 0.1;
V_FUM1= 1.1334; 
V_FUM2= 1.1334; 
Keq_FUM=10;

%----parameter for MDH version2--------------------------------------------
V_MDH1=25.874; 
V_MDH2=25.874;
Keq_MDH=1.0;
KI_MDHnad= 0.31;
KI_MDHnadh =0.04;
KI_MDHmal=3.30;
KI_MDHoaa=0.27;
Km_MDHnad=0.10;
Km_MDHnadh=0.04;
Km_MDHmal=1.33;
Km_MDHoaa=0.27;
KII_MDHnad=0.31;
KII_MDHoaa=0.17;

%##########################################################################
%                 ACETATE FORMATION 
%##########################################################################
%----parameter for PTA version 1 (hoefnagel, 2002)-------------------------
V_PTAmax = 0.83902*15; %0.15871*10; 
Ki_PTAaccoa = 0.2; 
Km_PTAp = 2.6; 
Ki_PTAp = 2.6; 
Ki_PTAacp = 0.2; 
Ki_PTAcoa = 0.029; 
Km_PTAacp = 0.7; 
Keq_PTA = 0.0281; 

%----parameter for ACK version 1-------------------------------------------
V_ACKmax =191.02*15; %191.02; 
Km_ACKacp = 0.16;  
Km_ACKadp = 0.5;
Km_ACKacet = 7; 
Km_ACKatp = 0.07; 
Keq_ACK = 174.2; 

%----parameter for ACS-----------------------------------------------------
  V_ACSmax = 0.089971*200; %0.089971*3
  Km2_ACS = 0.07; %ori- 0.1 0.07-from brenda database
  Keq_ACS = 0.15;

%##########################################################################
%             GLUCONEOGENESIS & ANAPLEORATIC PATHWAYS 
%##########################################################################
%----parameter for MEZ-----------------------------------------------------
V_MEZ= 0.1058; % 0.069945
Km_MEZmal=0.37;
Keq_MEZ=0.10;

%----parameter for PCK-----------------------------------------------------
V_PCKmax = 4.5116*10; 
Km_PCKatp = 0.06;
KI_PCKatp = 0.04;
Ki_PCKatp = 0.04;
Km_PCKoaa = 0.67;
Ki_PCKpep = 0.06;
KI_PCKoaa = 0.45;
Km_PCKpep = 0.07;
Ki_PCKadp = 0.04;

%----parameter for PPC-----------------------------------------------------
V_PPCmax2 =3.7719/20;  %3.7719/20; 
Km_PEP =0.3231; 
k1 = 0.03176 ; % ori-0.03176;   1.5
k2 = 1.2878;
k3 = 0.05425;
k4 = 0.8139;
k5 = 0.0939;
k6 = 0.2693;

%----parameter for PPC-------(Chassagnole, 2002)
V_PPCmax = 0.43622;  
K_PPCpep = 1;  %//original
K_PPCfdp =1;
n_PPCfdp = 4;

%##########################################################################
%             GLYCOXYLATE PATHWAY
%##########################################################################
%-----parameter for ICL----------------------------------------------------
V_ICLmax = 3.8315;
r_ICLmax_f = 3.8315;  %2.585
r_ICLmax_r = (3.8315/100); %2.585
K_ICLicit = 0.604; 
K_ICLsuc = 0.59;
K_ICLgox = 0.13;
I = 0.01; 
KI_ICL=0.003; 

K_ICLicit = 0.0104; % - 0.604
K_ICLsuc = 1.19; % - 1.19
K_ICLpep = 0.91; % - 0.91
K_ICL2kg = 1.35; % - 1.35

%----parameter for MS------------------------------------------------------
V_MSmax=3.6869;
Vf_MS =3.6869; %3.742  28.5 on acetate  13.742  2.585
Vr_MS =(3.6869/100); %3.742  28.5/100 
Km_MSgox = 2;
Km_MSaccoa =0.01;
Km_MSmal =1;
Km_MScoa = 0.1;
